package org.matrix.autotest.service.Impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.autotest.dao.ExampleMapper;
import org.matrix.autotest.entity.Example;
import org.matrix.autotest.service.ExampleService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Service
public class ExampleServiceImpl extends ServiceImpl<ExampleMapper, Example> implements ExampleService {

    private final ExampleMapper exampleMapper;

    public ExampleServiceImpl(ExampleMapper exampleMapper) {
        this.exampleMapper = exampleMapper;
    }

    @Override
    public List<Example> findAllExample() {
        return exampleMapper.selectList(null);
    }

    @Override
    public Example findByIdExample(Integer id) {
        return exampleMapper.selectById(id);
    }

    @Override
    public Example insertExample(Example example) {
        exampleMapper.insert(example);
        return example;
    }

    @Override
    public Example updateExample(Example example) {
        exampleMapper.updateById(example);
        return example;
    }

    @Override
    public Example deleteExample(Example example) {
        exampleMapper.deleteById(example.getId());
        return example;
    }
}
