package org.matrix.autotest.service.Impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.autotest.dao.TestCaseMapper;
import org.matrix.autotest.entity.TestCase;
import org.matrix.autotest.service.TestCaseService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Service
public class TestCaseServiceImpl extends ServiceImpl<TestCaseMapper, TestCase> implements TestCaseService {

    private final TestCaseMapper testCaseMapper;

    public TestCaseServiceImpl(TestCaseMapper testCaseMapper) {
        this.testCaseMapper = testCaseMapper;
    }

    @Override
    public List<TestCase> findAllTestCase() {
        return testCaseMapper.selectList(null);
    }

    @Override
    public TestCase findByIdTestCase(Integer id) {
        return testCaseMapper.selectById(id);
    }

    @Override
    public TestCase insertTestCase(TestCase testCase) {
        testCaseMapper.insert(testCase);
        return testCase;
    }

    @Override
    public TestCase updateTestCase(TestCase testCase) {
        testCaseMapper.updateById(testCase);
        return testCase;
    }

    @Override
    public TestCase deleteTestCase(TestCase testCase) {
        testCaseMapper.deleteById(testCase.getId());
        return testCase;
    }
}
