package org.matrix.autotest.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.autotest.entity.Move;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
public interface MoveService extends IService<Move> {
    /**
     * 查询所有行为
     *
     * @return 行为
     */
    List<Move> findAllMove();

    /**
     * 根据id查询行为
     *
     * @param id 行为id
     * @return 行为
     */
    Move findByIdMove(Integer id);

    /**
     * 添加行为
     *
     * @param move 行为
     * @return 添加的行为
     */
    Move insertMove(Move move);

    /**
     * 修改行为
     *
     * @param move 行为
     * @return 修改后的行为
     */
    Move updateMove(Move move);

    /**
     * 删除行为
     *
     * @param move 行为
     * @return 删除的行为
     */
    Move deleteMove(Move move);
}
