package org.matrix.database.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.database.entity.Project;
import org.matrix.database.mapper.ProjectMapper;
import org.matrix.database.service.IProjectService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Service
public class ProjectServiceImpl extends ServiceImpl<ProjectMapper, Project> implements IProjectService {

    private final ProjectMapper projectMapper;

    public ProjectServiceImpl(ProjectMapper projectMapper) {
        this.projectMapper = projectMapper;
    }

    @Override
    public List<Project> findAllProject() {
        return projectMapper.selectList(null);
    }

    @Override
    public int insertProject(Project project) {
        return projectMapper.insert(project);
    }

    @Override
    public int updateProject(Project project) {
        return projectMapper.updateById(project);
    }

    @Override
    public int deleteProject(Integer id) {
        return projectMapper.deleteById(id);
    }

}
