package org.matrix.database.vo;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

import java.util.Optional;
import java.util.function.Predicate;

/**
 * @author mry
 */
public class CommonResult {

    /**
     * 成功返回结果
     *
     * @param data 获取的数据
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> success(T data, HttpHeaders headers) {
        return new ResponseEntity(new CommonResultObj(data), headers, HttpStatus.OK);
    }

    /**
     * 运行predicate这段函数,如果返回值为true,返回值Response.ok(data),successMsg,否则返回failedMsg
     *
     * @param predicate 接受一段参数为T类型,返回值为boolean类型的函数
     * @param data predicate的参数
     * @param failedMsg 失败信息
     * @param <T> data类型
     * @return 如果成功,返回data自己,如果失败返回failedMsg给的错误信息
     */
    public static <T> ResponseEntity<CommonResultObj<T>> pred(Predicate<T> predicate, T data, String successMsg, String failedMsg) {
        if (predicate.test(data)){
            return success(data, successMsg);
        }else {
            return failed(data, failedMsg);
        }
    }

    /**
     * 成功返回结果
     *
     * @param data    获取的数据
     * @param message 提示信息
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> success(T data, String message) {
        return ResponseEntity.ok(new CommonResultObj<>(data, message));
    }

    /**
     * 成功返回结果
     *
     * @param message 提示信息
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> success(String message) {
        return ResponseEntity.ok(new CommonResultObj<>(null, message));
    }

    /**
     * 成功返回结果
     *
     * @param data
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> success(T data) {
        return ResponseEntity.ok(new CommonResultObj<>(data));
    }

    /**
     * 成功返回结果
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> success() {
        return ResponseEntity.ok(new CommonResultObj<>());
    }

    /**
     * 失败返回结果
     *
     * @param data 获取的数据
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> failed(T data, HttpHeaders headers) {
        return new ResponseEntity(new CommonResultObj(data), headers, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    /**
     * 失败返回结果
     *
     * @param data    获取的数据
     * @param message 提示信息
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> failed(T data, String message) {
        return ResponseEntity.status(500).body(new CommonResultObj<>(data, message));
    }

    /**
     * 失败返回结果
     *
     * @param message 提示信息
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> failed(String message) {
        return ResponseEntity.status(500).body(new CommonResultObj<>(null, message));
    }

    /**
     * 失败返回结果
     *
     * @param data 获取的数据
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> failed(T data) {
        return ResponseEntity.status(500).body(new CommonResultObj<>(data));
    }

    /**
     * 失败返回结果
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> failed() {
        return ResponseEntity.status(500).body(new CommonResultObj<>());
    }

}
