<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="./css/index.css">
    <link rel="stylesheet" href="./css/reset.css">
    <link rel="stylesheet" href="./css/bootstrap.css">
</head>

<body>
<div class="top">
    测试报告
</div>
<div class="content">
    <div class="topForm">
        <div class="topTitle">报告汇总</div>
        <form class="form">
            <div class="form-group flex">
                <label for="exampleInputEmail1">用例总数:</label>
                <span class="form-control" id="total">${overView.total!}</span>
            </div>
            <div class="form-group flex">
                <label for="exampleInputPassword1">执行时间(s):</label>
                <span class="form-control" id="allTime">${overView.allTime!}</span>
            </div>
            <div class="form-group flex">
                <label for="exampleInputPassword1">通过:</label>
                <span class="form-control" id="passNum">${overView.passNum!}</span>
            </div>
            <div class="form-group flex">
                <label for="exampleInputPassword1">失败:</label>
                <span class="form-control" id="failNum">${overView.failNum!}</span>
            </div>
            <div class="form-group flex">
                <label for="exampleInputPassword1">测试通过率:</label>
                <span class="form-control" id="probability">${overView.probability!}</span>
            </div>
        </form>
    </div>
    <div class="table">
        <table class="table table-striped">
            <thead>
            <tr>
                <th>编号</th>
                <th>用例名称</th>
                <th>用例类型</th>
                <th>详细参数</th>
                <th>用例描述</th>
                <th>执行结果</th>
                <th>执行时间</th>
                <th>结果信息</th>
            </tr>
            </thead>
            <tbody>
            <#assign caseNo = 0>
            <#if fail ??>
                <#list fail as failCase>
                    <tr>
                        <#assign caseNo=caseNo+1>
                        <th scope="row">${caseNo}</th>
                        <td>${failCase.testCaseName!}</td>
                        <td>${failCase.type!}</td>
                        <td>${failCase.detail!}</td>
                        <td>${failCase.description!}</td>
                        <td>${failCase.result?c}</td>
                        <td>${failCase.duration!}</td>
                        <td class="clickClass" data-message="${failCase.resultMessage!}">点击</td>
                    </tr>
                </#list>
            <#else>
            </#if>
            </tbody>
            <tbody>
            <#assign caseNo = 0>
            <#if pass ??>
                <#list pass as passCase>
                    <tr>
                        <#assign caseNo=caseNo+1>
                        <th scope="row">${caseNo}</th>
                        <td>${passCase.testCaseName!}</td>
                        <td>${passCase.type!}</td>
                        <td>${passCase.detail!}</td>
                        <td>${passCase.description!}</td>
                        <td>${passCase.result?c}</td>
                        <td>${passCase.duration!}</td>
                        <td class="clickClass" data-message="${passCase.resultMessage!}">点击</td>
                    </tr>
                </#list>
            <#else>
            </#if>
            </tbody>
        </table>
    </div>
</div>
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Modal title</h4>
            </div>
            <div class="modal-body">
                <form class="form-horizontal" id="grp">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary">Save changes</button>
            </div>
        </div>
    </div>
</div>
<script src="./js/jquery.min.js"></script>
<script src="./js/bootstrap.js"></script>
<script>
    function handleData(data) {
        let a = data
        let b = a.split('=').splice(1, a.split('=').length - 2)
        let c = b.join('=').split('(')[1].split(')')[0]
        let d = c.split(',')
        let e = []
        d.map(v => {
            e.push({key: v.split('=')[0], value: v.split('=')[1]})
        })
        return e
    }

    $(".clickClass").each((i, v) => {
        v.onclick = function () {
            if(!v.getAttribute('data-message')){
                alert('该条测试数据执行失败')
                return
            }
            let data = handleData(v.getAttribute('data-message'))
            $('#myModal').modal()
            if (data) {
                console.log(data)
                let oDiv = document.getElementById('grp')
                data.map(v => {
                    let div1 = document.createElement('div')
                    let lab1 = document.createElement('label')
                    let lab2 = document.createElement('label')
                    div1.className = 'form-group'
                    lab1.className = 'col-sm-4 control-label w20'
                    lab2.className = 'col-sm-6 control-label txtl'
                    lab1.innerText = v.key
                    lab2.innerText = v.value
                    div1.appendChild(lab1)
                    div1.appendChild(lab2)
                    oDiv.appendChild(div1)
                })

            }
        }
    })

</script>
</body>

</html>