package com.matrix.cona.controller;

import com.alibaba.fastjson.JSON;
import com.matrix.cona.entity.StandardData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Controller.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/30 at 6:22 下午
 * Suffering is the most powerful teacher of life.
 */
@RestController
@RequestMapping("/test")
public class TestController {

    private final String mailEndpoints = "mail";

    @Autowired
    private JmsMessagingTemplate jmsTemplate;

    /**
     * 将邮件内容发送到 邮件标准下的端点
     *
     * @param standardData 标准邮件内容
     * @return ResponseEntity
     */
    @PostMapping("/mail")
    public ResponseEntity<String> sendMail(@RequestBody StandardData standardData) {
        jmsTemplate.convertAndSend(mailEndpoints, JSON.toJSON(standardData).toString());
//        Map<String, String> result = new HashMap<>();
//        result.put("code", "200");
//        result.put("message", "success");
        return ResponseEntity.ok("发送成功");
    }
}
