package com.matirx.mail.gmail.service;

import com.matirx.mail.gmail.entity.MailInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Service;

/**
 * MailServiceImpl.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/25 at 1:41 上午
 * Suffering is the most powerful teacher of life.
 */
@Service
@Slf4j
public class MailServiceImpl implements MailService {

    @Autowired
    JavaMailSenderImpl mailSender;

    /**
     * 向指定地址以Gmail邮箱的形式发送邮件
     */
    @Override
    public void sendMail(MailInfo mailInfo) {
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setSubject(mailInfo.getTitle() + " - 来自新浪邮箱组件提供");
        mailMessage.setText(mailInfo.getContent());
        mailMessage.setTo(mailInfo.getMailAddress());
        mailMessage.setFrom("matrixldf@sina.com");
        log.info("[Sina mail] 准备发送邮件-发送数据 {}", mailInfo);
        mailSender.send(mailMessage);
    }
}
