package com.matirx.mail.gmail.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

/**
 * ScheduledTasks.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/25 at 1:05 上午
 * Suffering is the most powerful teacher of life.
 */
@Component
@Slf4j
public class ScheduledTasks {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private ObjectMapper objectMapper;

    private String registerUrl = "http://localhost:8180/server/register";

    /**
     * 每30秒进行一次心跳
     */
    @Scheduled(initialDelay = 5000, fixedRate = 30000)
    public void registerAndHeartBeat() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        ObjectNode serverNode = objectMapper.createObjectNode();
        serverNode.put("comNumber", "x001x001");
        serverNode.put("comAddress", "127.0.0.1");

        HttpEntity<String> request = new HttpEntity<>(serverNode.toString(), headers);

        String result = null;
        try {
            result = restTemplate.postForObject(registerUrl, request, String.class);
        } catch (RestClientException e) {
            log.debug("[Gmail] 没有找到消息总线服务器...");
        }
        log.info("register success , response = {}", result);
    }
}
