package com.matrix.mail.qq.controller;

import com.matrix.mail.qq.entity.MailInfo;
import com.matrix.mail.qq.service.MailService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * MailController.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/25 at 1:43 上午
 * Suffering is the most powerful teacher of life.
 */
@RestController
@RequestMapping("/mail")
@Api(tags = "邮件接口")
public class MailController {

    @Autowired
    private MailService mailService;

    @PostMapping("/send")
    public ResponseEntity<String> sendMail(@RequestBody MailInfo mailInfo) {
        mailService.sendMail(mailInfo);
        return ResponseEntity.ok("mail send success to " + mailInfo.getMailAddress());
    }
}
