package com.matrix.mail.qq.service;

import com.matrix.mail.qq.entity.MailInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Service;

/**
 * MailServiceImpl.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/25 at 1:41 上午
 * Suffering is the most powerful teacher of life.
 */
@Slf4j
@Service
public class MailServiceImpl implements MailService {

    @Autowired
    JavaMailSenderImpl mailSender;

    /**
     * 向指定地址以Gmail邮箱的形式发送邮件
     */
    @Override
    public void sendMail(MailInfo mailInfo) {
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setSubject(mailInfo.getTitle()+" - 来自QQ邮箱组件提供");
        mailMessage.setText(mailInfo.getContent());
        mailMessage.setTo(mailInfo.getMailAddress());
        mailMessage.setFrom("296796683@qq.com");
        log.info("[QQ mail] 准备发送邮件-发送数据 {}", mailInfo);
        mailSender.send(mailMessage);
    }
}
