package consumer;

import com.alibaba.fastjson.JSON;
import com.matrix.mail.qq.entity.MailInfo;
import com.matrix.mail.qq.service.MailService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

/**
 * SendConsumer. 邮件发送接口的消息消费服务
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/30 at 6:14 下午
 * Suffering is the most powerful teacher of life.
 */
@Slf4j
@Component
public class SendConsumer {

    private final String baseEndpoints = "x001x001.mail.send";

    @Autowired
    private MailService mailService;

    /**
     * 转发到邮件服务
     * @param text 消息体
     */
    @JmsListener(destination = baseEndpoints)
    public void receiveQueue(String text) {
        MailInfo mailInfo = JSON.parseObject(text, MailInfo.class);
        //1.调用服务发送邮件
        mailService.sendMail(mailInfo);
        //2.log
        log.info("[QQmail] 邮件发送完毕,送至 {} ",mailInfo.getMailAddress());
    }
}
