package com.matrix.md.bean;

import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * BeanHelper.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/1 at 1:32 下午
 * Suffering is the most powerful teacher of life.
 */
@Component
public class BeanHelper {

    private static ModelMapper mapper = new ModelMapper();

    static {
        mapper.getConfiguration().setAmbiguityIgnored(true);
        //设置为严格匹配
        mapper.getConfiguration().setFullTypeMatchingRequired(true);
        mapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);

    }

    public static ModelMapper getUserMapper() {
        return mapper;
    }

    @Bean
    public ModelMapper initModelMapper() {
        return mapper;
    }
}
