package com.matrix.md.bean;

import com.matrix.md.entity.vo.ServerInfo;
import lombok.Data;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * ShardingData.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/25 at 12:37 上午
 * Suffering is the most powerful teacher of life.
 */
@Data
@Component
public class ShardingData {

    /**
     * key = 组件编号 , value = 组件实际地址
     */
    private Map<String, String> componentAddress = new HashMap<>();

    public Map<String, String> registerAddress(ServerInfo serverInfo) {
        componentAddress.put(serverInfo.getComNumber(), serverInfo.getComAddress());
        return componentAddress;
    }
}
