package com.matrix.md.config;

import com.matrix.md.entity.vo.MessageMetrics;
import com.matrix.md.service.SpecService;
import lombok.extern.slf4j.Slf4j;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * ActiveMQUtil.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/2 at 2:39 AM
 * Suffering is the most powerful teacher of life.
 */
@Component
@Slf4j
public class ActiveMQUtil {

    @Autowired
    private ActivemqUtilConfig activemqUtilConfig;

    @Autowired
    private SpecService specService;

    public Map<String, MessageMetrics> getQueueInfos() {
        Map<String, MessageMetrics> queueMap = new HashMap<>();
        BrokerViewMBean mBean = null;
        MBeanServerConnection connection = null;
        try {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + activemqUtilConfig.getConnectorIp() + ":" + activemqUtilConfig.getConnectorPort() + activemqUtilConfig.getConnectorPath());
            JMXConnector connector = JMXConnectorFactory.connect(url);
            connector.connect();
            connection = connector.getMBeanServerConnection();
            ObjectName name = new ObjectName(activemqUtilConfig.getJmxDomain() + ":brokerName=" + activemqUtilConfig.getBrokerName() + ",type=Broker");
            mBean = MBeanServerInvocationHandler.newProxyInstance(connection, name, BrokerViewMBean.class, true);
        } catch (IOException | MalformedObjectNameException e) {
            log.error("ActiveMQUtil.getAllQueueSize", e);
        }

        if (mBean != null) {
            for (ObjectName queueName : mBean.getQueues()) {
                QueueViewMBean qm = MBeanServerInvocationHandler.newProxyInstance(connection, queueName, QueueViewMBean.class, true);
                if (qm.getName().contains("mail")) {
                    String name = "";
                    String processName = "";
                    if ("mail".equals(qm.getName())) {
                        name = "邮件规范";
                        Long comId = specService.getById(1).getCurrentComId();
                        if (comId == 1) {
                            processName = "qq邮箱组件";
                        }
                        if (comId == 2) {
                            processName = "新浪邮箱组件";
                        }
                    }

                    if ("x001x001.mail.send".equals(qm.getName())) {
                        name = "邮件规范子组件";
                        processName = "qq邮箱组件";
                    }

                    if ("x001x002.mail.send".equals(qm.getName())) {
                        name = "邮件规范子组件";
                        processName = "新浪邮箱组件";
                    }

                    MessageMetrics metrics = new MessageMetrics(
                            name, processName, "文本数据",qm.getName(), qm.getBlockedSends(),
                            qm.getConsumerCount(), qm.getEnqueueCount(), qm.getDequeueCount(),
                            qm.getMaxEnqueueTime(), qm.getMinEnqueueTime(), qm.getAverageEnqueueTime(),
                            qm.getMaxMessageSize(), qm.getMinMessageSize(), qm.getAverageMessageSize()
                    );
                    queueMap.put(qm.getName(), metrics);
                }
            }
        }

        return queueMap;
    }

}
