package com.matrix.md.consumer;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.matrix.md.entity.MessageLog;
import com.matrix.md.entity.Specification;
import com.matrix.md.entity.trans.MailInfo;
import com.matrix.md.entity.trans.StandardData;
import com.matrix.md.service.ComponentService;
import com.matrix.md.service.MessageLogService;
import com.matrix.md.service.SpecService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.stereotype.Component;

/**
 * MailConsumer. 邮件标准的消费服务
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/30 at 5:10 下午
 * Suffering is the most powerful teacher of life.
 */
@Slf4j
@Component
public class MailConsumer {

    private final String baseEndpoints = "mail";

    @Autowired
    private JmsMessagingTemplate jmsTemplate;

    @Autowired
    private SpecService specService;

    @Autowired
    private ComponentService comService;

    @Autowired
    private MessageLogService logService;


    /**
     * 转发到邮件服务
     *
     * @param text 消息体
     */
    @JmsListener(destination = baseEndpoints)
    public void receiveQueue(String text) {
        StandardData data = JSON.parseObject(text, StandardData.class);
        //1.获得当前正在服务的组件 - 获得实际的端点


        while (true){
            LambdaQueryWrapper<Specification> wrapper = new LambdaQueryWrapper<>();
            Long currentComId = specService.getOne(wrapper
                            .eq(Specification::getEndPoints, baseEndpoints))
                    .getCurrentComId();
            if (currentComId == 0){
                try {
                    Thread.sleep(1000L);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                currentComId = specService.getOne(wrapper
                                .eq(Specification::getEndPoints, baseEndpoints))
                        .getCurrentComId();

            }else {
                com.matrix.md.entity.Component component = comService.getById(currentComId);
                String endPoints = String.format("%s.%s.%s",
                        component.getComNumber(), baseEndpoints, data.getApi());
                MailInfo mailInfo = data.getData();
                //2.log
                String handleCom = "";

                if ("x001x001.mail.send".equals(endPoints)) {
                    handleCom = "qq邮箱组件";
                }

                if ("x001x002.mail.send".equals(endPoints)) {
                    handleCom = "新浪邮箱组件";
                }

                MessageLog sendLog = new MessageLog("文本数据", "测试组件1", handleCom, (long) data.getData().getContent().getBytes().length,
                        false, "成功");

                logService.save(sendLog);

                log.info("总线接受到mail标准下 {}组件请求，要访问的api是 {},实际路由的端点是{},发送给",
                        data.getFrom(), data.getApi(), endPoints);

                jmsTemplate.convertAndSend(endPoints, JSON.toJSON(mailInfo).toString());
                break;
            }
        }

    }

}
