package com.matrix.md.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.matrix.md.entity.BaseEntity;
import com.matrix.md.entity.Specification;
import com.matrix.md.entity.vo.ComponentVo;
import com.matrix.md.service.ComponentService;
import com.matrix.md.service.SpecService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.toMap;

/**
 * ComponentController.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/1 at 1:08 下午
 * Suffering is the most powerful teacher of life.
 */
@RestController
@RequestMapping("/components")
@Api(tags = "组件接口")
public class ComponentController {

    @Autowired
    private ComponentService componentService;

    @Autowired
    private SpecService specService;

    @GetMapping
    @ApiOperation(value = "分页获取组件页信息")
    public ResponseEntity<IPage<ComponentVo>> findAll(@RequestParam int page) {
        List<Specification> specList = specService.list();
        Map<Long, String> nameMap = specList.stream()
                .collect(toMap(BaseEntity::getId, Specification::getName));
        Map<Long, String> bindMap = specList.stream()
                .filter(s -> s.getCurrentComId() > 0)
                .collect(toMap(Specification::getCurrentComId, Specification::getName));

        // paging queries component and convert Page<Component> to Page<componentVo> by chain
        IPage<ComponentVo> pageVo = componentService.page(Page.of(page, 10))
                .convert(c -> ComponentVo.transVo(c, nameMap, bindMap));

        return ResponseEntity.ok(pageVo);
    }
}
