package com.matrix.md.controller;

import com.matrix.md.config.ActiveMQUtil;
import com.matrix.md.entity.vo.MessageMetrics;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * MessageController.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/24 at 5:07 下午
 */
@RestController
@RequestMapping("/messages")
@Api(tags = "总线通信管理接口")
public class MessageController {

    @Autowired
    private ActiveMQUtil mqUtil;

    @GetMapping
    @ApiModelProperty(value = "获取消息总线消息")
    public ResponseEntity<Map<String, MessageMetrics>> messages() {
        Map<String, MessageMetrics> queueInfos = mqUtil.getQueueInfos();
        return ResponseEntity.ok(queueInfos);
    }
}
