package com.matrix.md.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.matrix.md.entity.MessageLog;
import com.matrix.md.service.MessageLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

/**
 * MessageLogController.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/2 at 4:04 AM
 * Suffering is the most powerful teacher of life.
 */
@RequestMapping("/messageLogs")
@RestController
@Api(tags = "消息日志接口")
public class MessageLogController {

    private final MessageLogService messageLogService;

    public MessageLogController(MessageLogService messageLogService) {
        this.messageLogService = messageLogService;
    }


    /**
     * paging query message logs.
     */
    @GetMapping
    @ApiOperation("分页查询消息日志")
    public ResponseEntity<Page<MessageLog>> query(int page) {
        Page<MessageLog> messageLogs = messageLogService.page(new Page<>(page, 10));
        return ResponseEntity.ok(messageLogs);

    }

}
