package com.matrix.md.controller;

import com.matrix.md.bean.ShardingData;
import com.matrix.md.entity.vo.ServerInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * ServerController.
 * 服务器的路由器，用于处理组件注册.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/25 at 12:35 上午
 * Suffering is the most powerful teacher of life.
 */
@RestController
@RequestMapping("/server")
@Api(tags = "服务发现注册Demo")
public class ServerController {

    @Autowired
    private ShardingData shardingData;

    @ApiOperation("服务地址的注册与更新")
    @PostMapping("/register")
    public ResponseEntity<String> register(@RequestBody ServerInfo serverInfo){
        shardingData.registerAddress(serverInfo);
        return ResponseEntity.ok("register success");
    }

    @ApiOperation("展示服务列表")
    @GetMapping("/list")
    public ResponseEntity<Map<String,String>> showServerList(){
        return ResponseEntity.ok(shardingData.getComponentAddress());
    }
}
