package com.matrix.md.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.beans.Transient;
import java.time.LocalDateTime;

/**
 * Component.
 * 组件对象
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/22 at 4:02 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("组件对象")
public class Component extends BaseEntity{

    @ApiModelProperty(value = "组件编号")
    private String comNumber;

    @ApiModelProperty(value = "组件名称")
    private String name;

    @ApiModelProperty(value = "组件ip")
    private String ip;

    @ApiModelProperty(value = "该组件适用的规范列表Id,以英文状态下的逗号','作为分隔符")
    private String specAbleIds;

}
