package com.matrix.md.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;

/**
 * InterInfo.
 * interface-information 接口信息 - Demo中与{@link Specification} 强绑定
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/22 at 5:17 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("接口信息")
public class InterInfo extends BaseEntity {

    @ApiModelProperty("接口名称")
    private String name;

    @ApiModelProperty("接口描述")
    private String des;

    @ApiModelProperty("接口地址")
    private String address;

    @ApiModelProperty("请求方式 HTTP-GET/HTTP-POST/SOCKET")
    private String requestMethod;

    @ApiModelProperty("参数类型 - JSON")
    private String paramType;

    @ApiModelProperty("关联的规范主键id")
    private Long specId;

}
