package com.matrix.md.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * InterParam.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/22 at 5:19 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("接口参数")
public class InterParam extends BaseEntity {

    @ApiModelProperty("参数名称")
    private String fieldName;

    @ApiModelProperty("参数描述")
    private String fieldDes;

    @ApiModelProperty("参数类型")
    private String fieldType;

    @ApiModelProperty("是否必填 1true-必须填 0false-非必填")
    private boolean required;

    @ApiModelProperty("关联的接口信息id")
    private Long infoId;
}
