package com.matrix.md.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * InterResponse.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/22 at 5:20 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("接口返回值")
public class InterResponse extends BaseEntity{

    @ApiModelProperty("返回值参数名称")
    private String fieldName;

    @ApiModelProperty("返回值参数描述")
    private String fieldDes;

    @ApiModelProperty("返回值参数类型")
    private String fieldType;

    @ApiModelProperty("返回值关联的接口信息id")
    private Long infoId;
}
