package com.matrix.md.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * MessageLog.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/2 at 3:57 AM
 * Suffering is the most powerful teacher of life.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("消息日志")
public class MessageLog extends BaseEntity {

    @ApiModelProperty("数据类型")
    private String dataType;

    @ApiModelProperty("发送组件")
    private String sendCom;

    @ApiModelProperty("接收组件")
    private String handleCom;

    @ApiModelProperty("数据大小")
    private Long dataSize;

    @ApiModelProperty("是否限流")
    private boolean isLimit;

    @ApiModelProperty("通信结果")
    private String result;

}
