package com.matrix.md.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * PageData.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/1 at 10:24 PM
 * Suffering is the most powerful teacher of life.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "分页数据")
public class PageData<T> {

    @ApiModelProperty(value = "当前页码")
    private int page;

    @ApiModelProperty(value = "每页条数")
    private int size;

    @ApiModelProperty(value = "总条数")
    private int total;

    @ApiModelProperty(value = "数据")
    private T data;

}
