package com.matrix.md.entity;

import com.matrix.md.bean.BeanHelper;
import com.matrix.md.entity.vo.SpecificationVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

/**
 * Specification.
 * 规范标准
 * 和组件的关系是组件可以实现多个规范，规范当前只能选择某一个组件作为当前规范的实现，一个组件可以同时服务多个规范
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/22 at 4:00 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "规范标准")
public class Specification extends BaseEntity {

    @ApiModelProperty(value = "规范的名称")
    private String name;

    @ApiModelProperty(value = "规范编号")
    private String specNumber;

    @ApiModelProperty(value = "规范的描述")
    private String des;

    @ApiModelProperty(value = "绑定的MQ的端点")
    private String endPoints;

    @ApiModelProperty(value = "规范的适用范围")
    private String applyRange;

    @ApiModelProperty(value = "规范当前绑定的组件id,如果没有绑定则为0，默认为0")
    private Long currentComId = 0L;

    public SpecificationVo toVo(String currentComName) {
        ModelMapper mapper = BeanHelper.getUserMapper();
        SpecificationVo vo = mapper.map(this, SpecificationVo.class);
        vo.setComName(currentComName);
        return vo;
    }


}



