package com.matrix.md.entity.vo;

import com.matrix.md.bean.BeanHelper;
import com.matrix.md.entity.Component;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * ComponentVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/1 at 1:11 下午
 * Suffering is the most powerful teacher of life.
 */
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("组件的显示层")
public class ComponentVo extends Component {

    @ApiModelProperty(value = "绑定的名称，没有绑定显示无")
    private String bindingName;

    @ApiModelProperty(value = "适用的规范名称列表")
    private List<String> adaptList;

    public static ComponentVo transVo(Component component, Map<Long, String> specNameMap, Map<Long, String> bindMap) {
        ModelMapper mapper = BeanHelper.getUserMapper();
        ComponentVo vo = mapper.map(component, ComponentVo.class);
        String bindingName = bindMap.getOrDefault(vo.getId(), "无");
        List<String> adaptList = Arrays.stream(vo.getSpecAbleIds().split(","))
                .map(Long::valueOf)
                .map(key -> specNameMap.getOrDefault(key,"暂无适配规范"))
                .collect(Collectors.toList());

        vo.setBindingName(bindingName);
        vo.setAdaptList(adaptList);

        return vo;
    }


}
