package com.matrix.md.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * MessageMetrics.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/2 at 2:52 AM
 * Suffering is the most powerful teacher of life.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("消息统计指标")
public class MessageMetrics {

    @ApiModelProperty("通信规范名称")
    private String name;

    @ApiModelProperty("关联组件名称")
    private String processName;

    @ApiModelProperty("消息数据类型")
    private String type;

    @ApiModelProperty("端点名称")
    private String endpoint;

    @ApiModelProperty("正在处理的消息数")
    private Long pending;

    @ApiModelProperty("应用组件数量")
    private Long consumers;

    @ApiModelProperty("已发送消息数")
    private Long enqueued;

    @ApiModelProperty("已处理消息数")
    private Long dequeued;

    @ApiModelProperty("最大滞留时间")
    private Long maxEnqueuedTime;

    @ApiModelProperty("最小滞留时间")
    private Long minEnqueuedTime;

    @ApiModelProperty("平均滞留时间")
    private Double avgEnqueuedTime;

    @ApiModelProperty("最大消息大小")
    private Long maxMessageSize;



    @ApiModelProperty("最小消息大小")
    private Long minMessageSize;

    @ApiModelProperty("平均消息大小")
    private Long avgMessageSize;

}
