package com.matrix.md.service;

import com.matrix.md.entity.Specification;

import java.util.List;

/**
 * MessageService.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/22 at 7:13 下午
 */
public interface MessageService {

    /**
     * 查询所有可用规范的当前状态
     */
    List<Specification> findAllSpecs();

    /**
     * 更改绑定
     *
     * @param specId      规范id
     * @param componentId 新绑定的组件主键id
     * @return 是否绑定成功
     */
    boolean updateBindComponent(Long specId, Long componentId);

    Specification findByEndpoints(String endPoints);

}
