package com.matrix.md.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.matrix.md.entity.InterInfo;
import com.matrix.md.entity.InterParam;
import com.matrix.md.entity.InterResponse;
import com.matrix.md.entity.vo.InterVo;
import com.matrix.md.mapper.InterInfoMapper;
import com.matrix.md.mapper.InterParamMapper;
import com.matrix.md.mapper.InterResponseMapper;
import com.matrix.md.service.InterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * InterServiceImpl.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/2 at 4:39 PM
 * Suffering is the most powerful teacher of life.
 */
@Service
public class InterServiceImpl extends ServiceImpl<InterInfoMapper, InterInfo> implements InterService {

    @Autowired
    private InterInfoMapper infoMapper;

    @Autowired
    private InterParamMapper paramMapper;

    @Autowired
    private InterResponseMapper responseMapper;


    @Override
    public List<InterVo> getInterfaceBySpecId(Long specId) {
        LambdaQueryWrapper<InterInfo> infoWrapper = new LambdaQueryWrapper<>();
        return infoMapper.selectList(infoWrapper.eq(InterInfo::getSpecId, specId)).stream()
                .map(this::assemblingInterface)
                .collect(Collectors.toList());
    }


    /**
     * 组装接口信息
     *
     * @param info 基础接口
     * @return 组装后的接口信息
     */
    private InterVo assemblingInterface(InterInfo info) {
        InterVo vo = new InterVo();
        vo.setInterInfo(info);
        LambdaQueryWrapper<InterParam> paramWrapper = new LambdaQueryWrapper<>();
        LambdaQueryWrapper<InterResponse> responseWrapper = new LambdaQueryWrapper<>();
        List<InterParam> params = paramMapper.selectList(paramWrapper.eq(InterParam::getInfoId, info.getId()));
        List<InterResponse> response = responseMapper.selectList(responseWrapper.eq(InterResponse::getInfoId, info.getId()));
        vo.setInterParams(params);
        vo.setInterResponses(response);
        return vo;
    }
}
