package com.matrix.md.websocket;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * ComponentFlow. 组件流量
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/3 at 11:15 AM
 * Suffering is the most powerful teacher of life.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("组件流量")
public class ComponentFlow {

    @ApiModelProperty("组件名称")
    private String name;

    @ApiModelProperty("上行流-kb")
    private double upStream;

    @ApiModelProperty("下行流-kb")
    private double downStream;

    @ApiModelProperty("关联类型 1-关联正常,2-需要被处理,3-无流量")
    private int type;
}
