package com.matrix.md.websocket;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;


/**
 * socketData.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/2 at 7:30 PM
 * Suffering is the most powerful teacher of life.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("监控页面的webSocket数据")
@JsonPropertyOrder({"timeStamp", "transFlow", "componentFlows"})
public class SocketData {


    @JsonIgnore
    private static long activeComponent = 1;

    @ApiModelProperty("时间戳 yyyy-MM-dd hh:mm:ss")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "Asia/Shanghai")
    private LocalDateTime timeStamp;

    @ApiModelProperty("传输流量")
    private TransFlow transFlow;

    @ApiModelProperty("组件流量列表")
    private List<ComponentFlow> componentFlows;

    /**
     * 生产一组组件的流量
     *
     * @return 组件流量
     */
    public static SocketData produce() {
        TransFlow transFlow = TransFlow.produce();
        List<ComponentFlow> flows = new ArrayList<>();
        Random random = new Random();
        double variance = 0.5;

        ComponentFlow consumer = new ComponentFlow("消费组件A", Math.sqrt(variance) * random.nextGaussian() + Math.random() * 100, Math.sqrt(variance) * random.nextGaussian() + Math.random() * 100, 1);
        flows.add(consumer);

        ComponentFlow qqMail = new ComponentFlow();
        ComponentFlow sinaMail = new ComponentFlow();


        if (activeComponent == 0) {
            qqMail = new ComponentFlow("QQ邮箱组件", 0, 0, 3);
            sinaMail = new ComponentFlow("新浪邮箱组件", 0, 0, 3);
        }

        if (activeComponent == 1) {
            qqMail = new ComponentFlow("QQ邮箱组件", Math.sqrt(variance) * random.nextGaussian() + Math.random() * 100, Math.sqrt(variance) * random.nextGaussian() + Math.random() * 100, 1);
            sinaMail = new ComponentFlow("新浪邮箱组件", 0, 0, 3);
        }

        if (activeComponent == 2) {
            qqMail = new ComponentFlow("QQ邮箱组件", 0, 0, 3);
            sinaMail = new ComponentFlow("新浪邮箱组件", Math.sqrt(variance) * random.nextGaussian() + Math.random() * 100, Math.sqrt(variance) * random.nextGaussian() + Math.random() * 100, 1);
        }



        flows.add(qqMail);
        flows.add(sinaMail);

        return new SocketData(LocalDateTime.now(), transFlow, flows);
    }

    /**
     * update activeComponent
     */
    public static void updateActiveComponent(long updatedActiveComponent) {
        activeComponent = updatedActiveComponent;
    }

    /**
     * a method that return Incremental random number
     */
    public static long getIncrementalRandomNumber() {
        return Math.round(Math.random() * 100);
    }
}



