package com.matrix.md.websocket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * socketTask.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/2 at 7:30 PM
 * Suffering is the most powerful teacher of life.
 */
@Component
@Slf4j
public class SocketTask {

    private int count;

    @Autowired
    private ObjectMapper objectMapper;

    /**
     * 每2秒发送一次socketData
     */
    @Scheduled(initialDelay = 5000, fixedRate = 1000)
    public void sendSocketData() throws JsonProcessingException {
        //使用 jackson 将对象转换为json字符串

        if (WebSocket.webSocketSets.size() > 0) {
            String testData = objectMapper.writeValueAsString(SocketData.produce());
            WebSocket.sendMessage(testData);
        }
    }

}
