package com.matrix.md.websocket;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Random;

/**
 * TransFlow.传输流量
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/12/3 at 11:12 AM
 * Suffering is the most powerful teacher of life.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("传输流量,单位kb")
public class TransFlow {

    @JsonIgnore
    private static int seed = 2;
    @JsonIgnore
    private static double maxFlow = 2;

    @ApiModelProperty("当前流量")
    private double current;
    @ApiModelProperty("总流量")
    private double total;
    @ApiModelProperty("平均流量")
    private double average;
    @ApiModelProperty("最大流量")
    private double max;

    /**
     * 生产TransFlow数据,方差为1
     */
    public static TransFlow produce() {
        Random random = new Random();

        maxFlow = Math.max(Math.sqrt(1) * random.nextGaussian() + (Math.random() + 2) * 100, maxFlow);
        double avg = 120 + 10 * (Math.random() * 2 - 1);

        return new TransFlow(
                Math.sqrt(1) * random.nextGaussian() + Math.random() * 100,
                (Math.random() + seed++) * 200,
                avg,
                maxFlow);
    }

}
