# reset tables
use message_demo;
DROP TABLE IF EXISTS specification;

CREATE TABLE specification
(
    id             BIGINT(20)  NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    create_time    datetime    NULL     DEFAULT NULL COMMENT '创建时间',
    update_time    datetime    NULL     DEFAULT NULL COMMENT '更新时间',
    name           VARCHAR(50) NULL     DEFAULT NULL COMMENT '规范的名称',
    spec_number    VARCHAR(50) NULL     DEFAULT NULL COMMENT '规范编号',
    des            VARCHAR(50) NULL     DEFAULT NULL COMMENT '规范的描述',
    end_points     VARCHAR(50) NULL     DEFAULT NULL COMMENT '绑定的MQ的端点',
    apply_range    VARCHAR(50) NULL     DEFAULT NULL COMMENT '规范的适用范围',
    current_com_id bigint(20)  not null default 0 COMMENT '规范当前绑定的组件id,如果没有绑定则为0，默认为0',
    PRIMARY KEY (id)
) comment '规范标准';


DROP TABLE IF EXISTS component;

CREATE TABLE component
(
    id            BIGINT(20)  NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    create_time   datetime    NULL DEFAULT NULL COMMENT '创建时间',
    update_time   datetime    NULL DEFAULT NULL COMMENT '更新时间',
    com_number    VARCHAR(50) NULL DEFAULT NULL COMMENT 'ip',
    ip            VARCHAR(50) NULL DEFAULT NULL COMMENT '组件编号',
    name          VARCHAR(50) NULL DEFAULT NULL COMMENT '组件名称',
    spec_able_ids VARCHAR(50) NULL DEFAULT NULL COMMENT '组件适用的规范列表Id',
    PRIMARY KEY (id)
) comment '组件';

drop table if exists message_log;

DROP TABLE IF EXISTS inter_info;


CREATE TABLE inter_info
(
    id             BIGINT(20)  NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    create_time    datetime    NULL     DEFAULT NULL COMMENT '创建时间',
    update_time    datetime    NULL     DEFAULT NULL COMMENT '更新时间',
    name           VARCHAR(50) NULL     DEFAULT NULL COMMENT '接口名称',
    des            VARCHAR(50) NULL     DEFAULT NULL COMMENT '接口描述',
    address        VARCHAR(50) NULL     DEFAULT NULL COMMENT '接口地址',
    request_method VARCHAR(50) NULL     DEFAULT NULL COMMENT '请求方式 HTTP-GET/HTTP-POST/SOCKET',
    param_type     VARCHAR(50) NULL     DEFAULT NULL COMMENT '参数类型 - JSON',
    spec_id        bigint(20)  not null default 0 COMMENT '关联的规范主键id',
    PRIMARY KEY (id)
) comment '接口信息';

drop table if exists message_log;

create table message_log
(
    id          BIGINT(20)  NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    create_time datetime    NULL DEFAULT NULL COMMENT '创建时间',
    update_time datetime    NULL DEFAULT NULL COMMENT '更新时间',
    data_type   VARCHAR(50) NULL DEFAULT NULL COMMENT '数据类型',
    send_com    VARCHAR(50) NULL DEFAULT NULL COMMENT '发送组件',
    handle_com  VARCHAR(50) NULL DEFAULT NULL COMMENT '处理组件',
    data_size   VARCHAR(50) NULL DEFAULT NULL COMMENT '数据大小',
    is_limit    boolean     NULL DEFAULT NULL COMMENT '是否限流',
    result      VARCHAR(50) NULL DEFAULT NULL COMMENT '通信结果',
    PRIMARY KEY (id)
) comment '消息日志';


DROP TABLE IF EXISTS inter_param;

CREATE TABLE inter_param
(
    id          BIGINT(20)  NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    create_time datetime    NULL     DEFAULT NULL COMMENT '创建时间',
    update_time datetime    NULL     DEFAULT NULL COMMENT '更新时间',
    field_name  VARCHAR(50) NULL     DEFAULT NULL COMMENT '参数名称',
    field_des   VARCHAR(50) NULL     DEFAULT NULL COMMENT '参数描述',
    field_type  VARCHAR(50) NULL     DEFAULT NULL COMMENT '参数类型',
    required    boolean     not null default true COMMENT '是否必填 1true-必须填 0false-非必填',
    info_id     bigint(20)  not null default 0 COMMENT '关联的接口信息id',
    PRIMARY KEY (id)
) comment '接口参数';


DROP TABLE IF EXISTS inter_response;

CREATE TABLE inter_response
(
    id          BIGINT(20)  NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    create_time datetime    NULL     DEFAULT NULL COMMENT '创建时间',
    update_time datetime    NULL     DEFAULT NULL COMMENT '更新时间',
    field_name  VARCHAR(50) NULL     DEFAULT NULL COMMENT '返回值参数名称',
    field_des   VARCHAR(50) NULL     DEFAULT NULL COMMENT '返回值参数描述',
    field_type  VARCHAR(50) NULL     DEFAULT NULL COMMENT '返回值参数类型',
    info_id     bigint(20)  not null default 0 COMMENT '关联的接口信息id',
    PRIMARY KEY (id)
) comment '接口返回值';

