/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3;

import com.kingbase8.core.Field;
import com.kingbase8.core.NativeQuery;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.Query;
import com.kingbase8.core.SqlCommand;
import com.kingbase8.core.Utils;
import com.kingbase8.core.v3.SimpleParameterList;
import com.kingbase8.core.v3.TypeTransferModeRegistry;
import com.kingbase8.jdbc.KbResultSet;
import java.lang.ref.PhantomReference;
import java.util.Map;

public class SimpleQuery
implements Query {
    private Map<String, Integer> resultSetColumnNameIndexMap;
    private final NativeQuery nativeQuery;
    private final TypeTransferModeRegistry transferModeRegistry;
    private String statementName;
    private byte[] encodedStatementName;
    private Field[] fields;
    private boolean needUpdateFieldFormats;
    private boolean hasBinaryFields;
    private boolean portalDescribed;
    private boolean statementDescribed;
    private final boolean sanitiserDisabled;
    private PhantomReference<?> cleanupRef;
    private int[] preparedTypes;
    private short deallocateEpoch;
    private Integer cachedMaxResultRowSize;
    static final SimpleParameterList NO_PARAMETERS = new SimpleParameterList(0, null);
    private boolean needNextResult;

    SimpleQuery(SimpleQuery src) {
        this(src.nativeQuery, src.transferModeRegistry, src.sanitiserDisabled);
    }

    SimpleQuery(NativeQuery query, TypeTransferModeRegistry transferModeRegistry, boolean sanitiserDisabled) {
        this.nativeQuery = query;
        this.transferModeRegistry = transferModeRegistry;
        this.sanitiserDisabled = sanitiserDisabled;
    }

    @Override
    public ParameterList createParameterList() {
        if (this.nativeQuery.bindPositions.length == 0) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.getBindCount(), this.transferModeRegistry);
    }

    @Override
    public String toString(ParameterList parameters) {
        return this.nativeQuery.toString(parameters);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public void close() {
        this.unprepare();
    }

    public SimpleQuery[] getSubqueries() {
        return null;
    }

    public int getMaxResultRowSize() {
        if (this.cachedMaxResultRowSize != null) {
            return this.cachedMaxResultRowSize;
        }
        if (!this.statementDescribed) {
            throw new IllegalStateException("Cannot estimate result row size on a statement that is not described");
        }
        int maxResultRowSize = 0;
        if (this.fields != null) {
            for (Field f : this.fields) {
                int fieldLength = f.getLength();
                if (fieldLength < 1 || fieldLength >= 65535) {
                    maxResultRowSize = -1;
                    break;
                }
                maxResultRowSize += fieldLength;
            }
        }
        this.cachedMaxResultRowSize = maxResultRowSize;
        return maxResultRowSize;
    }

    @Override
    public String getNativeSql() {
        return this.nativeQuery.nativeSql;
    }

    void setStatementName(String statementName, short deallocateEpoch) {
        assert (statementName != null) : "statement name should not be null";
        this.statementName = statementName;
        this.encodedStatementName = Utils.encodeUTF8(statementName);
        this.deallocateEpoch = deallocateEpoch;
    }

    void setStatementTypes(int[] paramTypes) {
        this.preparedTypes = paramTypes;
    }

    int[] getStatementTypes() {
        return this.preparedTypes;
    }

    String getStatementName() {
        return this.statementName;
    }

    boolean isPreparedFor(int[] paramTypes, short deallocateEpoch) {
        if (this.statementName == null) {
            return false;
        }
        if (this.deallocateEpoch != deallocateEpoch) {
            return false;
        }
        assert (this.preparedTypes == null || paramTypes.length == this.preparedTypes.length) : String.format("paramTypes:%1$d preparedTypes:%2$d", paramTypes.length, paramTypes == null ? -1 : this.preparedTypes.length);
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i] == 0 || paramTypes[i] == this.preparedTypes[i]) continue;
            return false;
        }
        return true;
    }

    boolean hasUnresolvedTypes() {
        if (this.preparedTypes == null) {
            return true;
        }
        for (int preparedType : this.preparedTypes) {
            if (preparedType != 0) continue;
            return true;
        }
        return false;
    }

    byte[] getEncodedStatementName() {
        return this.encodedStatementName;
    }

    void setFields(Field[] fields) {
        this.fields = fields;
        this.resultSetColumnNameIndexMap = null;
        this.cachedMaxResultRowSize = null;
        this.needUpdateFieldFormats = fields != null;
        this.hasBinaryFields = false;
    }

    Field[] getFields() {
        return this.fields;
    }

    boolean needUpdateFieldFormats() {
        if (this.needUpdateFieldFormats) {
            this.needUpdateFieldFormats = false;
            return true;
        }
        return false;
    }

    public boolean hasBinaryFields() {
        return this.hasBinaryFields;
    }

    public void setHasBinaryFields(boolean hasBinaryFields) {
        this.hasBinaryFields = hasBinaryFields;
    }

    boolean isPortalDescribed() {
        return this.portalDescribed;
    }

    void setPortalDescribed(boolean portalDescribed) {
        this.portalDescribed = portalDescribed;
        this.cachedMaxResultRowSize = null;
    }

    @Override
    public boolean isStatementDescribed() {
        return this.statementDescribed;
    }

    void setStatementDescribed(boolean statementDescribed) {
        this.statementDescribed = statementDescribed;
        this.cachedMaxResultRowSize = null;
    }

    @Override
    public boolean isEmpty() {
        return this.getNativeSql().isEmpty();
    }

    void setCleanupRef(PhantomReference<?> cleanupRef) {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
        }
        this.cleanupRef = cleanupRef;
    }

    void unprepare() {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
            this.cleanupRef = null;
        }
        this.statementName = null;
        this.encodedStatementName = null;
        this.fields = null;
        this.resultSetColumnNameIndexMap = null;
        this.portalDescribed = false;
        this.statementDescribed = false;
        this.cachedMaxResultRowSize = null;
    }

    @Override
    public int getBatchSize() {
        return 1;
    }

    NativeQuery getNativeQuery() {
        return this.nativeQuery;
    }

    public final int getBindCount() {
        return this.nativeQuery.bindPositions.length * this.getBatchSize();
    }

    @Override
    public Map<String, Integer> getResultSetColumnNameIndexMap() {
        Map<String, Integer> columnPositions = this.resultSetColumnNameIndexMap;
        if (columnPositions == null && this.fields != null) {
            columnPositions = KbResultSet.createColumnNameIndexMap(this.fields, this.sanitiserDisabled);
            if (this.statementName != null) {
                this.resultSetColumnNameIndexMap = columnPositions;
            }
        }
        return columnPositions;
    }

    @Override
    public SqlCommand getSqlCommand() {
        return this.nativeQuery.getCommand();
    }

    @Override
    public boolean hasForUpdate() {
        return this.nativeQuery.forupdate;
    }

    public boolean isNeedNextResult() {
        return this.needNextResult;
    }

    public void setNeedNextResult(boolean needNextResult) {
        this.needNextResult = needNextResult;
    }
}

