/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.entity;

import com.kingbase8.Driver;
import com.kingbase8.KBNotification;
import com.kingbase8.KBProperty;
import com.kingbase8.copy.CopyManager;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.Encoding;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.ReplicationProtocol;
import com.kingbase8.core.TransactionState;
import com.kingbase8.core.TypeInfo;
import com.kingbase8.core.Version;
import com.kingbase8.dispatcher.core.ConnectionMangerV2;
import com.kingbase8.dispatcher.entity.FakeConnection;
import com.kingbase8.dispatcher.executor.DispatchCallableStatementV2;
import com.kingbase8.dispatcher.executor.DispatchPreparedStatementV2;
import com.kingbase8.dispatcher.executor.DispatchStatementV2;
import com.kingbase8.fastpath.Fastpath;
import com.kingbase8.jdbc.AutoSave;
import com.kingbase8.jdbc.FieldMetadata;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.jdbc.TimestampUtils;
import com.kingbase8.largeobject.LargeObjectManager;
import com.kingbase8.replication.KBReplicationConnection;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import com.kingbase8.util.LruCache;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class DispatchConnection
implements BaseConnection {
    private PreparedStatement checkConnectionQuery;
    private final boolean replicationConnection;
    private int transStatus;
    private String dispatcherSessionId;
    private Connection mainConn;
    boolean bmaster_check = false;
    public int retrytimes = 0;
    public int retryinterval = 0;
    SQLException master_error = null;
    public Integer sessionID = new Integer(-1);
    public String passward;
    public String dbName;
    public Properties m_props = new Properties();
    public String url;
    private Map<String, Connection> slaveConnMap = new HashMap<String, Connection>();
    private Map<String, Map<String, String>> slaveConnInfo = new HashMap<String, Map<String, String>>();
    public static String SLAVE = "slave";
    public int slaveCount;
    public List<String> whiteList = null;
    public List<String> blackList = null;
    public List<String> masterFunctionList = null;
    public List<String> tempTables = null;
    protected volatile boolean autoCommit = true;
    protected volatile boolean hasUpdate = false;

    public Connection getMainConn() throws SQLException {
        if (this.mainConn != null && !this.mainConn.isClosed()) {
            return this.mainConn;
        }
        boolean bconnect = true;
        KbConnection con = null;
        try {
            con = new KbConnection(Driver.hostSpecs(this.m_props), Driver.user(this.m_props), Driver.database(this.m_props), this.m_props, this.url);
        }
        catch (SQLException e) {
            String debugmsg = String.format("Create Master connection for : {%s} Exception: {%s}", Driver.hostSpecs(this.m_props)[0].getHost(), e.getMessage());
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, debugmsg);
                LOGGER.log(Level.SEVERE, e);
            }
            if (!this.bmaster_check) {
                throw new SQLException(e);
            }
            this.master_error = new SQLException(e);
            bconnect = false;
        }
        if (!bconnect) {
            String hostip = Driver.hostSpecs(this.m_props)[0].getHost();
            this.mainConn = new FakeConnection("masterkey", hostip);
            return this.mainConn;
        }
        con.sessionID = Driver.recycleSessions.size() > 0 ? (Integer)Driver.recycleSessions.remove(0) : new Integer(Driver.sessionID.getAndIncrement());
        this.sessionID = con.sessionID;
        con.setDispatchConn(this);
        con.setIsSlave(false);
        this.mainConn = con;
        return this.mainConn;
    }

    public boolean isHasUpdate() {
        return this.hasUpdate;
    }

    public void setHasUpdate(boolean hasUpdate) {
        this.hasUpdate = hasUpdate;
    }

    public DispatchConnection(KbConnection main_Conn, String pass_ward, String db_Name, Properties prop_s) throws SQLException {
        this.mainConn = main_Conn;
        this.passward = pass_ward;
        this.dbName = db_Name;
        this.m_props = prop_s;
        this.bmaster_check = KBProperty.MASTER_CHECK.getBoolean(prop_s);
        this.retrytimes = KBProperty.RETRYTIMES.getIntNoCheck(prop_s);
        this.retryinterval = KBProperty.RETRYINTERVAL.getIntNoCheck(prop_s);
        this.whiteList = this.initFunctionList(KBProperty.WHITELIST.get(prop_s));
        this.blackList = this.initFunctionList(KBProperty.BLACKLIST.get(prop_s));
        this.masterFunctionList = this.initFunctionList(KBProperty.MASTERFUNCTIONLIST.get(prop_s));
        this.tempTables = this.initFunctionList(KBProperty.TEMPTABLE.get(prop_s));
        this.initSlavesInfo(this.m_props);
        this.url = this.getUrl();
        this.getMasterConnection();
        this.getAllSlaveConn();
        if (this.bmaster_check) {
            this.CheckClusteInfo(prop_s);
        }
        this.replicationConnection = KBProperty.REPLICATION.get(this.m_props) != null;
    }

    public List<String> initFunctionList(String function) {
        if (function != null) {
            String[] funs;
            ArrayList<String> functions = new ArrayList<String>();
            for (String fun : funs = function.split(";")) {
                int start = 0;
                int index = fun.indexOf("\"", start);
                String str = "";
                boolean flag = false;
                while (index != -1) {
                    str = !flag ? str + fun.substring(start, index).toLowerCase() : str + fun.substring(start, index);
                    flag = !flag;
                    start = index + 1;
                    index = fun.indexOf("\"", start);
                }
                str = str + fun.substring(start, fun.length()).toLowerCase();
                functions.add(str);
            }
            return functions;
        }
        return null;
    }

    public void initSlavesInfo(Properties props) {
        int index;
        String slaveadd = KBProperty.SLAVE_ADD.get(props);
        this.slaveConnInfo.clear();
        this.slaveCount = 0;
        if (slaveadd == null || slaveadd.isEmpty()) {
            return;
        }
        String slaveport = KBProperty.SLAVE_PORT.get(props);
        String[] slave_add = slaveadd.split(",");
        String[] slave_port = slaveport.split(",");
        int count = slave_add.length;
        for (index = 0; index < count; ++index) {
            String key = "slave" + index;
            HashMap<String, String> info = new HashMap<String, String>();
            this.slaveConnInfo.put(key, info);
            info.put("ADDRESS", slave_add[index]);
            info.put("PORT", slave_port[0]);
        }
        this.slaveCount = index;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, " slaveConnInfo (session={0} ADDRESS={1},PORT={2})", new Object[]{this.sessionID, slaveadd, slaveport});
        }
    }

    public Connection createSlaveConnection(String key) throws SQLException {
        Map<String, String> infoMap = this.slaveConnInfo.get(key);
        String url = "jdbc:kingbase8://" + infoMap.get("ADDRESS") + ":" + infoMap.get("PORT") + "/" + this.dbName;
        LOGGER.log(Level.SEVERE, "createSlaveConnection key " + key + " " + url);
        try {
            KbConnection conn = null;
            Properties slave_props = new Properties(this.m_props);
            slave_props.setProperty("HOST", infoMap.get("ADDRESS"));
            slave_props.setProperty("PORT", infoMap.get("PORT"));
            conn = new KbConnection(Driver.hostSpecs(slave_props), Driver.user(slave_props), Driver.database(slave_props), slave_props, url);
            conn.setDispatchConn(this);
            conn.setMasterConnection(this.mainConn);
            conn.setIsSlave(true);
            this.slaveConnMap.put(key, conn);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "create SlaveConnection success (session={0} url={1})", new Object[]{this.sessionID, url});
            }
            return conn;
        }
        catch (SQLException e) {
            String debugmsg = String.format("Create Slave connection for : {key:%s %s} Exception: {%s}", key, infoMap.get("ADDRESS"), e.getMessage());
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, debugmsg);
                LOGGER.log(Level.SEVERE, e);
            }
            Connection tagConn = this.setSlaveToFakebyKey(key);
            return tagConn;
        }
    }

    public Connection setSlaveToFakebyKey(String key) throws SQLException {
        Map<String, String> infoMap = this.slaveConnInfo.get(key);
        String debugmsg = String.format("set Slave connection to Fake state for : {key:%s %s} ", key, infoMap.get("ADDRESS"));
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, debugmsg);
        }
        FakeConnection tagConn = new FakeConnection(key, infoMap.get("ADDRESS"));
        this.slaveConnMap.put(key, tagConn);
        return tagConn;
    }

    public Connection getSlaveConnection(String key) throws SQLException {
        LOGGER.log(Level.INFO, "getSlaveConnection key:" + key);
        if (key == null) {
            return this.mainConn;
        }
        Connection conn = null;
        if (!this.slaveConnMap.containsKey(key)) {
            conn = this.createSlaveConnection(key);
        } else {
            conn = this.slaveConnMap.get(key);
            if (conn == null || conn.isClosed() && !(conn instanceof FakeConnection) || conn instanceof FakeConnection && ((FakeConnection)conn).getSlaveStatus()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    String debugmsg = conn instanceof FakeConnection ? String.format("getSlaveConnection recreate fake slave connection for : {%s}", ((FakeConnection)conn).getSlaveIP()) : (conn != null ? String.format("getSlaveConnection recreate KbConnection slave connection for : {%s}", ((KbConnection)conn).getURL()) : String.format("getSlaveConnection recreate null slave connection", new Object[0]));
                    LOGGER.log(Level.INFO, debugmsg);
                }
                conn = this.createSlaveConnection(key);
            }
        }
        return conn;
    }

    public List<Connection> getAllSlaveConn() throws SQLException {
        LOGGER.log(Level.INFO, "getAllSlaveConn slaveCount:" + this.slaveCount + "\n");
        ArrayList<Connection> conns = new ArrayList<Connection>();
        for (int i = 0; i < this.slaveCount; ++i) {
            String key = SLAVE + i;
            conns.add(this.getSlaveConnection(key));
        }
        return conns;
    }

    protected String getUrl() {
        String url = "jdbc:kingbase8://" + KBProperty.KB_HOST.get(this.m_props) + ":" + KBProperty.KB_PORT.get(this.m_props) + "/" + this.dbName + "?hostLoadRate=" + KBProperty.HOSTLOADRATE.get(this.m_props);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block11: {
            Boolean useconn_pool = KBProperty.USECONNECT_POOL.getBoolean(this.m_props);
            if (useconn_pool.booleanValue()) {
                LOGGER.log(Level.INFO, "dispatch close():::connect pool reset this connect to idle sessionID: {0}", this.sessionID);
                Object object = ConnectionMangerV2.lock;
                synchronized (object) {
                    if (!ConnectionMangerV2.pool_used.isEmpty()) {
                        ConnectionMangerV2.pool_used.remove(this);
                    }
                    if (!this.isClosed()) {
                        ConnectionMangerV2.pool_available.push(this);
                    }
                }
                return;
            }
            try {
                LOGGER.log(Level.INFO, "dispatch close()");
                this.mainConn.close();
            }
            catch (SQLException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                LOGGER.log(Level.SEVERE, "mainConn close Exception (Exception={0})", new Object[]{e.getMessage()});
                LOGGER.log(Level.SEVERE, e);
            }
        }
        Iterator<Connection> it = this.slaveConnMap.values().iterator();
        while (it.hasNext()) {
            try {
                it.next().close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "slaveConnMap close Exception (Exception={0})", new Object[]{e.getMessage()});
                LOGGER.log(Level.SEVERE, e);
            }
        }
    }

    public void checkslavestatus() throws SQLException {
        for (int i = 0; i < this.slaveCount; ++i) {
            String key = SLAVE + i;
            Connection con = this.getSlaveConnection(key);
            if (con instanceof FakeConnection) {
                if (!this.checkslaveisup(((FakeConnection)con).getSlaveIP())) continue;
                if (LOGGER.isLoggable(Level.INFO)) {
                    String debugmsg = String.format("checkslavestatus recreate slave connection for : {%s}", ((FakeConnection)con).getSlaveIP());
                    LOGGER.log(Level.INFO, debugmsg);
                }
                ((FakeConnection)con).setSlaveStatus(true);
                continue;
            }
            try {
                if (con.isValid(5)) continue;
                con.close();
                LOGGER.log(Level.INFO, "checkslavestatus: find connect on " + ((KbConnection)con).getHostIp() + " is invalid  need reconnect\n");
                FakeConnection tagConn = new FakeConnection(key, ((KbConnection)con).getHostIp());
                this.slaveConnMap.put(key, tagConn);
                tagConn.setSlaveStatus(false);
                continue;
            }
            catch (SQLException e) {
                LOGGER.log(Level.INFO, "checkslavestatus Exception: " + e.getMessage() + " find connect on " + ((KbConnection)con).getHostIp() + " is invalid  need reconnect\n");
                FakeConnection tagConn = new FakeConnection(key, ((KbConnection)con).getHostIp());
                this.slaveConnMap.put(key, tagConn);
                tagConn.setSlaveStatus(false);
            }
        }
    }

    public boolean checkslaveisup(String slaveip) throws SQLException {
        boolean bres = false;
        Connection conn = this.mainConn;
        String sql = String.format("select CLIENT_ADDR from sys_stat_replication where CLIENT_ADDR = '%s' ", slaveip);
        try {
            if (conn == null || conn instanceof FakeConnection) {
                return false;
            }
            if (conn.isClosed()) {
                return false;
            }
            Statement stcheck = conn.createStatement();
            ResultSet rs = stcheck.executeQuery(sql);
            bres = rs.next();
            LOGGER.log(Level.INFO, "checkslaveisup: " + sql + " slaveip: " + slaveip + " status: " + bres);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
            LOGGER.log(Level.SEVERE, e);
        }
        return bres;
    }

    public void CloseConnectCluter() throws SQLException {
        try {
            LOGGER.log(Level.INFO, "recreate cluster connection");
            this.mainConn.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "mainConn close Exception (Exception={0})", new Object[]{e.getMessage()});
            LOGGER.log(Level.SEVERE, e);
        }
        Iterator<Connection> it = this.slaveConnMap.values().iterator();
        while (it.hasNext()) {
            try {
                Connection con = it.next();
                con.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "slaveConnMap close Exception (Exception={0})", new Object[]{e.getMessage()});
                LOGGER.log(Level.SEVERE, e);
            }
        }
    }

    public void ReConnectCluter() throws SQLException {
        this.slaveConnMap.clear();
        this.getMasterConnection();
        this.getAllSlaveConn();
        this.setHasUpdate(false);
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void commit() throws SQLException {
        this.mainConn.commit();
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.commit();
        }
        this.setHasUpdate(false);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.mainConn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.mainConn.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.mainConn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.mainConn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.mainConn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.mainConn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.mainConn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.mainConn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.mainConn.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.mainConn.nativeSQL(sql);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new DispatchStatementV2(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DispatchStatementV2(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DispatchStatementV2(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new DispatchCallableStatementV2(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DispatchCallableStatementV2(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DispatchCallableStatementV2(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.mainConn.releaseSavepoint(savepoint);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.releaseSavepoint(savepoint);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.mainConn.rollback();
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.rollback();
        }
        this.setHasUpdate(false);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.mainConn.rollback(savepoint);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.rollback(savepoint);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.mainConn.setAutoCommit(autoCommit);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setAutoCommit(autoCommit);
        }
        if (this.autoCommit != autoCommit) {
            this.autoCommit = autoCommit;
            this.setHasUpdate(false);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.mainConn.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.mainConn.setHoldability(holdability);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setHoldability(holdability);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.mainConn.setReadOnly(readOnly);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setReadOnly(readOnly);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setSavepoint();
        }
        return this.mainConn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            connection.setSavepoint(name);
        }
        return this.mainConn.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.mainConn.setTransactionIsolation(level);
        if (level != 8) {
            List<Connection> conns = this.getAllSlaveConn();
            for (Connection connection : conns) {
                if (connection instanceof FakeConnection) continue;
                connection.setTransactionIsolation(level);
            }
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.mainConn.setTypeMap(map);
    }

    public void addWarning(SQLWarning warn) {
        ((KbConnection)this.mainConn).addWarning(warn);
    }

    @Override
    public void cancelQuery() throws SQLException {
        ((KbConnection)this.mainConn).cancelQuery();
    }

    @Override
    public ResultSet execSQLQuery(String s) throws SQLException {
        return ((KbConnection)this.mainConn).execSQLQuery(s);
    }

    @Override
    public ResultSet execSQLQuery(String s, int resultSetType, int resultSetConcurrency) throws SQLException {
        return ((KbConnection)this.mainConn).execSQLQuery(s, resultSetType, resultSetConcurrency);
    }

    public String getCursorName() throws SQLException {
        return ((KbConnection)this.mainConn).getCursorName();
    }

    @Override
    public Encoding getEncoding() {
        return ((KbConnection)this.mainConn).getEncoding();
    }

    public void setCursorName(String cursor) throws SQLException {
        ((KbConnection)this.mainConn).setCursorName(cursor);
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        return ((KbConnection)this.mainConn).getFastpathAPI();
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return ((KbConnection)this.mainConn).getQueryExecutor();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new KSQLException(GT.tr("Invalid timeout ({0}<0).", timeout), KSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            if (this.replicationConnection) {
                Statement statement = this.createStatement();
                statement.execute("IDENTIFY_SYSTEM");
                statement.close();
            } else {
                if (this.checkConnectionQuery == null) {
                    this.checkConnectionQuery = this.prepareStatement("");
                }
                this.checkConnectionQuery.setQueryTimeout(timeout);
                this.checkConnectionQuery.executeUpdate();
            }
            return true;
        }
        catch (SQLException e) {
            if (KSQLState.IN_FAILED_SQL_TRANSACTION.getState().equals(e.getSQLState())) {
                return true;
            }
            LOGGER.log(Level.WARNING, GT.tr("Validating connection.", new Object[0]), e);
            return false;
        }
    }

    @Override
    public void setMasterConnection(Connection conn) {
        this.mainConn = (KbConnection)conn;
        this.sessionID = ((KbConnection)this.mainConn).sessionID;
        ((KbConnection)this.mainConn).setDispatchConn(this);
        ((KbConnection)this.mainConn).setIsSlave(false);
    }

    public boolean CheckIsMaster(Connection conn) {
        boolean bres = false;
        try {
            if (conn == null || conn instanceof FakeConnection) {
                return bres;
            }
            LOGGER.log(Level.INFO, "CheckIsMaster" + ((KbConnection)conn).getURL() + "\n");
            if (conn.isClosed()) {
                return bres;
            }
            Statement stcheck = conn.createStatement();
            ResultSet rs = stcheck.executeQuery("select CLIENT_ADDR from sys_stat_replication");
            bres = rs.next();
            rs.close();
            if (bres) {
                return bres;
            }
            rs = stcheck.executeQuery("select * from sys_is_in_recovery()");
            if (rs.next()) {
                bres = !rs.getBoolean(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
            LOGGER.log(Level.SEVERE, e);
        }
        return bres;
    }

    public Properties UpdateSlaveinfoFromMaster(Properties props) throws SQLException {
        Statement stcheck = this.mainConn.createStatement();
        ResultSet rs = stcheck.executeQuery("select CLIENT_ADDR from sys_stat_replication ");
        StringBuffer slave_ip = new StringBuffer("");
        while (rs.next()) {
            if (slave_ip.length() == 0) {
                slave_ip.append(rs.getString("CLIENT_ADDR"));
                continue;
            }
            slave_ip.append(",");
            slave_ip.append(rs.getString("CLIENT_ADDR"));
        }
        KBProperty.SLAVE_ADD.set(props, slave_ip.toString());
        stcheck.close();
        Properties props_new = new Properties(props);
        return props_new;
    }

    public boolean CheckClusteInfo(Properties prop_s) throws SQLException {
        Connection old_mainconn;
        boolean bMasterChange = false;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "CheckClusteInfo prop_s  host: " + KBProperty.KB_HOST.get(prop_s) + " slaveadd: " + KBProperty.SLAVE_ADD.get(prop_s) + "\n");
        }
        if ((old_mainconn = this.mainConn) == null) {
            // empty if block
        }
        if (this.CheckIsMaster(this.mainConn)) {
            return bMasterChange;
        }
        bMasterChange = true;
        if (bMasterChange) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "CheckClusteInfo slaveConnMap size()" + this.slaveConnMap.size() + " " + this.slaveConnMap.toString() + "\n");
            }
            for (Map.Entry<String, Connection> entry : this.slaveConnMap.entrySet()) {
                String key = entry.getKey();
                Connection slavecon = entry.getValue();
                if (!this.CheckIsMaster(slavecon)) continue;
                this.setMasterConnection(slavecon);
                if (!(old_mainconn instanceof FakeConnection)) {
                    ((KbConnection)old_mainconn).setIsSlave(true);
                }
                this.slaveConnMap.put(key, old_mainconn);
                bMasterChange = true;
                String old_masterip = KBProperty.KB_HOST.get(prop_s);
                String new_masterip = ((KbConnection)slavecon).getHostIp();
                KBProperty.KB_HOST.set(prop_s, new_masterip);
                String old_slaveip = KBProperty.SLAVE_ADD.get(prop_s);
                String new_slaveip = old_slaveip.replace(new_masterip, old_masterip);
                KBProperty.SLAVE_ADD.set(prop_s, new_slaveip);
                this.m_props = prop_s;
                String cluster_port = KBProperty.KB_PORT.get(prop_s);
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("ADDRESS", old_masterip);
                info.put("PORT", cluster_port);
                this.slaveConnInfo.put(key, info);
                if (!LOGGER.isLoggable(Level.INFO)) break;
                String debugmsg = String.format("CheckClusteInfo::Cluster Change Master DB from " + old_masterip + " to " + new_masterip, new Object[0]);
                LOGGER.log(Level.INFO, debugmsg);
                break;
            }
        }
        if (!this.CheckIsMaster(this.mainConn)) {
            throw new SQLException("JDBC can't find a vaild master database in cluster...");
        }
        return bMasterChange;
    }

    @Override
    public Connection getMasterConnection() throws SQLException {
        return this.getMainConn();
    }

    public Properties getConnectionProperties() {
        return this.m_props;
    }

    public void setConnectionProperties(Properties props) {
        this.m_props = props;
    }

    public void setTransStatus(int transStatus) {
        this.transStatus = transStatus;
    }

    public int getTransStatus() {
        return this.transStatus;
    }

    public boolean isCompatibleOldDateFormat() {
        return false;
    }

    @Override
    public boolean isSlave() {
        return false;
    }

    @Override
    public void setIsSlave(boolean isSlave) {
    }

    @Override
    public boolean isZeroResend() {
        return false;
    }

    public boolean isUseSlaveSynRead() {
        return false;
    }

    public boolean checkDBLinkSql() {
        return false;
    }

    @Override
    public KBNotification[] getNotifications() throws SQLException {
        return ((KbConnection)this.mainConn).getNotifications();
    }

    @Override
    public CopyManager getCopyAPI() throws SQLException {
        return ((KbConnection)this.mainConn).getCopyAPI();
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        return ((KbConnection)this.mainConn).getLargeObjectAPI();
    }

    @Override
    public void addDataType(String type, String className) {
        ((KbConnection)this.mainConn).addDataType(type, className);
    }

    @Override
    public void addDataType(String type, Class<? extends KBobject> klass) throws SQLException {
        ((KbConnection)this.mainConn).addDataType(type, klass);
    }

    @Override
    public void setPrepareThreshold(int threshold) {
        ((KbConnection)this.mainConn).setPrepareThreshold(threshold);
    }

    @Override
    public int getPrepareThreshold() {
        return ((KbConnection)this.mainConn).getPrepareThreshold();
    }

    @Override
    public void setDefaultFetchSize(int fetchSize) throws SQLException {
        ((KbConnection)this.mainConn).setDefaultFetchSize(fetchSize);
    }

    @Override
    public int getDefaultFetchSize() {
        return ((KbConnection)this.mainConn).getDefaultFetchSize();
    }

    @Override
    public int getBackendPID() {
        return ((KbConnection)this.mainConn).getBackendPID();
    }

    @Override
    public String escapeIdentifier(String identifier) throws SQLException {
        return ((KbConnection)this.mainConn).escapeIdentifier(identifier);
    }

    @Override
    public String escapeLiteral(String literal) throws SQLException {
        return ((KbConnection)this.mainConn).escapeIdentifier(literal);
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return ((KbConnection)this.mainConn).getPreferQueryMode();
    }

    @Override
    public AutoSave getAutosave() {
        return ((KbConnection)this.mainConn).getAutosave();
    }

    @Override
    public void setAutosave(AutoSave autoSave) {
        ((KbConnection)this.mainConn).setAutosave(autoSave);
    }

    @Override
    public KBReplicationConnection getReplicationAPI() {
        return ((KbConnection)this.mainConn).getReplicationAPI();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.mainConn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.mainConn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.mainConn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.mainConn.createSQLXML();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.mainConn.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.mainConn.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.mainConn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.mainConn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.mainConn.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.mainConn.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        ((KbConnection)this.mainConn).setSchema(schema);
        List<Connection> conns = this.getAllSlaveConn();
        for (Connection connection : conns) {
            if (connection instanceof FakeConnection) continue;
            ((KbConnection)connection).setSchema(schema);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        return ((KbConnection)this.mainConn).getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        ((KbConnection)this.mainConn).abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        ((KbConnection)this.mainConn).setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return ((KbConnection)this.mainConn).getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.mainConn.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.mainConn.isWrapperFor(iface);
    }

    @Override
    public void execSQLUpdate(String s) throws SQLException {
        ((KbConnection)this.mainConn).execSQLQuery(s);
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        return ((KbConnection)this.mainConn).getReplicationProtocol();
    }

    @Override
    public Object getObject(String type, String value, byte[] byteValue) throws SQLException {
        return ((KbConnection)this.mainConn).getObject(type, value, byteValue);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return ((KbConnection)this.mainConn).getTypeInfo();
    }

    @Override
    public boolean haveMinimumServerVersion(int ver) {
        return ((KbConnection)this.mainConn).haveMinimumServerVersion(ver);
    }

    @Override
    public boolean haveMinimumServerVersion(Version ver) {
        return ((KbConnection)this.mainConn).haveMinimumServerVersion(ver);
    }

    @Override
    public byte[] encodeString(String str) throws SQLException {
        return ((KbConnection)this.mainConn).encodeString(str);
    }

    @Override
    public String escapeString(String str) throws SQLException {
        return ((KbConnection)this.mainConn).escapeString(str);
    }

    @Override
    public boolean getStandardConformingStrings() {
        return ((KbConnection)this.mainConn).getStandardConformingStrings();
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        return ((KbConnection)this.mainConn).getTimestampUtils();
    }

    @Override
    public boolean getStringVarcharFlag() {
        return ((KbConnection)this.mainConn).getStringVarcharFlag();
    }

    @Override
    public TransactionState getTransactionState() {
        return ((KbConnection)this.mainConn).getTransactionState();
    }

    @Override
    public boolean binaryTransferSend(int oid) {
        return ((KbConnection)this.mainConn).binaryTransferSend(oid);
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return ((KbConnection)this.mainConn).isColumnSanitiserDisabled();
    }

    @Override
    public void addTimerTask(TimerTask timerTask, long milliSeconds) {
        ((KbConnection)this.mainConn).addTimerTask(timerTask, milliSeconds);
    }

    @Override
    public void purgeTimerTasks() {
        ((KbConnection)this.mainConn).purgeTimerTasks();
    }

    @Override
    public LruCache<FieldMetadata.Key, FieldMetadata> getFieldMetadataCache() {
        return ((KbConnection)this.mainConn).getFieldMetadataCache();
    }

    @Override
    public CachedQuery createQuery(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) throws SQLException {
        return ((KbConnection)this.mainConn).createQuery(sql, escapeProcessing, isParameterized, columnNames);
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        ((KbConnection)this.mainConn).setFlushCacheOnDeallocate(flushCacheOnDeallocate);
    }
}

