package com.matrix.md.utils;

import com.gitee.flying.cattle.mdg.entity.BasisInfo;
import com.gitee.flying.cattle.mdg.util.EntityInfoUtil;
import com.gitee.flying.cattle.mdg.util.Generator;
import com.gitee.flying.cattle.mdg.util.MySqlToJavaUtil;

import java.sql.SQLException;

/**
 * SwaggerCodeGenerator.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/5/13 at 3:21 下午
 */
public class SwaggerCodeGenerator {
    // 基础信息：项目名、作者、版本
    public static final String PROJECT = "sharding-platform-demo";
    public static final String AUTHOR = "matrix";
    public static final String VERSION = "V1.0";
    // 数据库连接信息：连接URL、用户名、秘密、数据库名
    public static final String URL = "jdbc:mysql://localhost:3306/sdb?useSSL=false&serverTimezone=UTC&characterEncoding=utf-8&allowPublicKeyRetrieval=true";
    public static final String NAME = "root";
    public static final String PASS = "ldf123456";
    public static final String DATABASE = "sdb";
    // 类信息：类名、对象名（一般是【类名】的首字母小些）、类说明、时间
    public static final String CLASSNAME = "foreign";
    public static final String TABLE = "pm_foreign";
    public static final String CLASSCOMMENT = "API应用KEY";
    public static final String TIME = "2019年10月16日";
    public static final String AGILE = System.currentTimeMillis() + "";
    // 路径信息，分开路径方便聚合工程项目，微服务项目
    public static final String ENTITY_URL = "com.matrix.md.sdb.entity";
    public static final String DAO_URL = "com.matrix.md.sdb.mapper";
    public static final String XML_URL = "com.matrix.md.sdb.mapper.xml";
    public static final String SERVICE_URL = "com.matrix.md.sdb.service";
    public static final String SERVICE_IMPL_URL = "com.matrix.md.sdb.service.impl";
    public static final String CONTROLLER_URL = "com.matrix.md.sdb.controller";
    //是否是Swagger配置
    public static final String IS_SWAGGER = "true";

    public static void main(String[] args) {
        BasisInfo bi = new BasisInfo(PROJECT, AUTHOR, VERSION, URL, NAME, PASS, DATABASE, TIME, AGILE, ENTITY_URL,
                DAO_URL, XML_URL, SERVICE_URL, SERVICE_IMPL_URL, CONTROLLER_URL, IS_SWAGGER);
        bi.setTable(TABLE);
        bi.setEntityName(MySqlToJavaUtil.getClassName(TABLE));
        bi.setObjectName(MySqlToJavaUtil.changeToJavaFiled(TABLE));
        bi.setEntityComment(CLASSCOMMENT);
        try {
            bi = EntityInfoUtil.getInfo(bi);
            String projectPath = System.getProperty("user.dir");
            // 生成文件存放位置
            String fileUrl = "projectPath" + "/src/main/java";
            //开始生成文件
            String aa1 = Generator.createEntity(fileUrl, bi).toString();
            String aa2 = Generator.createDao(fileUrl, bi).toString();
            String aa3 = Generator.createDaoImpl(fileUrl, bi).toString();
            String aa4 = Generator.createService(fileUrl, bi).toString();
            String aa5 = Generator.createServiceImpl(fileUrl, bi).toString();
            String aa6 = Generator.createController(fileUrl, bi).toString();
            // 是否创建swagger配置文件
            String aa7 = Generator.createSwaggerConfig(fileUrl, bi).toString();

            System.out.println(aa1);
            System.out.println(aa2);
            System.out.println(aa3);
            System.out.println(aa4);
            System.out.println(aa5);
            System.out.println(aa6);
            System.out.println(aa7);

        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

}
