package com.matrix.md.sys.controller;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.matrix.md.sys.entity.User;
import com.matrix.md.sys.mapper.UserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author matrix
 * @since 2020-05-11
 */
@Controller
@RequestMapping("/sys/user")
public class UserController {

    @Autowired
    private UserMapper userMapper;

    @GetMapping
    public ResponseEntity findUsers() {
        LambdaQueryWrapper<User> query = Wrappers.lambdaQuery();
        query.ge(User::getAge, 18);
        List<User> userList = userMapper.selectList(query);
        return ResponseEntity.ok(userList);

    }
}
