/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.executor;

import com.kingbase8.KBProperty;
import com.kingbase8.core.ParameterList;
import com.kingbase8.dispatcher.core.ConnectionMangerV2;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.dispatcher.entity.FakeConnection;
import com.kingbase8.dispatcher.executor.command.StatementCreateCommand;
import com.kingbase8.dispatcher.parser.statement.BeginStatement;
import com.kingbase8.dispatcher.parser.statement.EndStatement;
import com.kingbase8.dispatcher.parser.statement.Statement;
import com.kingbase8.dispatcher.sqlParser.sql.SqlParser;
import com.kingbase8.jdbc.KbCallableStatement;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.jdbc.KbPreparedStatement;
import com.kingbase8.jdbc.KbStatement;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public abstract class DispatchAbstractStatement {
    public static final int DISPATCH_TYPE_MAIN = 0;
    public static final int DISPATCH_TYPE_SLAVE = 1;
    public static final int DISPATCH_TYPE_ALL = 2;
    public static final int DISPATCH_TYPE_ALL_CURRENT = 3;
    protected DispatchConnection dispatchConnection;
    protected java.sql.Statement mainStatement;
    protected java.sql.Statement slaveStatement;
    protected Boolean replaceProcessingEnabled = null;
    protected Integer maxFieldSize = null;
    protected Integer fetchSize = null;
    protected Integer maxrows = null;
    protected Integer fetchdirection = null;
    protected Integer timeout = null;
    protected String cursor = null;
    StatementCreateCommand<? extends java.sql.Statement> createCommand = null;
    String strategyValue = null;
    String sqlType;
    private boolean slaveConnectionDisable = false;
    protected volatile int dispatchType = 0;
    protected volatile int currentDispatchType = 0;
    ParameterList record_main_prepl = null;
    ParameterList record_slave_prepl = null;
    java.sql.Statement record_main_stmt = null;
    java.sql.Statement record_slave_stmt = null;
    private static final String TYPE_INTRANSACTION = "in transaction";
    private static final String TYPE_SELECT = "select";
    private static final String TYPE_SET = "set or reset";
    private static final String TYPE_UPDATE = "insert or delete or update";
    private String slavekey = "";

    public void cleanStatement() throws SQLException {
        if (this.mainStatement != null) {
            this.record_main_stmt = this.mainStatement;
            this.mainStatement.close();
            this.mainStatement = null;
        }
        if (this.slaveStatement != null) {
            this.record_slave_stmt = this.slaveStatement;
            this.slaveStatement.close();
            this.slaveStatement = null;
        }
    }

    public java.sql.Statement getMainStatement() throws SQLException {
        if (this.mainStatement == null) {
            this.mainStatement = this.createCommand.getStatement(this.dispatchConnection.getMainConn());
            this.initStatement(this.mainStatement);
        }
        return this.mainStatement;
    }

    public List<java.sql.Statement> getAllStatement() throws SQLException {
        ArrayList<java.sql.Statement> result = new ArrayList<java.sql.Statement>();
        result.add(this.getMainStatement());
        int slaveCount = this.dispatchConnection.slaveCount;
        while (slaveCount-- > 0) {
            if (this.slaveStatement != null) {
                this.slaveStatement = null;
            }
            this.slaveStatement = this.getSlaveStatement();
            if (this.slaveStatement == null) continue;
            result.add(this.slaveStatement);
        }
        return result;
    }

    public java.sql.Statement getSlaveStatement() throws SQLException {
        if (this.slaveStatement == null) {
            String key;
            this.slavekey = key = DispatchConnection.SLAVE + ConnectionMangerV2.lastSlaveID.getAndIncrement() % this.dispatchConnection.slaveCount;
            Connection conn = this.dispatchConnection.getSlaveConnection(key);
            if (conn instanceof FakeConnection) {
                String dmsg = String.format("getSlaveStatement: slave_online_ip is : {%s}  FakeConnection is: {%s}", ConnectionMangerV2.slave_online_ip, ((FakeConnection)conn).getSlaveIP());
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, dmsg);
                }
                String sip = ConnectionMangerV2.slave_online_ip;
                String[] sip_arr = sip.split(",");
                int i = 0;
                for (i = 0; i < sip_arr.length; ++i) {
                    if (!sip_arr[i].equalsIgnoreCase(((FakeConnection)conn).getSlaveIP())) continue;
                    ((FakeConnection)conn).setSlaveStatus(true);
                    String debugmsg = String.format("getSlaveStatement: need recreate slave connection for : {%s}", ((FakeConnection)conn).getSlaveIP());
                    if (!LOGGER.isLoggable(Level.INFO)) break;
                    LOGGER.log(Level.INFO, debugmsg);
                    break;
                }
                if (!((FakeConnection)conn).getSlaveStatus()) {
                    String masterip = "";
                    String debugmsg = "";
                    Connection mastercon = this.dispatchConnection.getMainConn();
                    if (mastercon instanceof KbConnection) {
                        masterip = ((KbConnection)mastercon).getHostIp();
                        debugmsg = String.format("getSlaveStatement: offline slave connection for : {%s} and Master ip is :{%s}", ((FakeConnection)conn).getSlaveIP(), masterip);
                    } else if (mastercon instanceof FakeConnection) {
                        masterip = ((FakeConnection)mastercon).getSlaveIP();
                        debugmsg = String.format("getSlaveStatement: offline slave connection for : {%s} and FakeMaster ip is :{%s}", ((FakeConnection)conn).getSlaveIP(), masterip);
                    }
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, debugmsg);
                    }
                }
                return null;
            }
            this.slaveStatement = this.createCommand.getStatement(conn);
            this.initStatement(this.slaveStatement);
        }
        return this.slaveStatement;
    }

    public List<java.sql.Statement> getAllCurrentStatement() throws SQLException {
        ArrayList<java.sql.Statement> result = new ArrayList<java.sql.Statement>();
        if (this.mainStatement != null) {
            result.add(this.mainStatement);
        }
        if (this.slaveStatement != null) {
            result.add(this.slaveStatement);
        }
        return result;
    }

    protected int getExecuteType(String sql) {
        int result;
        block12: {
            result = 0;
            if (this.dispatchConnection.slaveCount == 0) {
                this.currentDispatchType = 0;
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, " getExecuteType (session={0} sql={1})", new Object[]{this.dispatchConnection, sql});
                }
                return this.currentDispatchType;
            }
            if (this.strategyValue == null) {
                this.strategyValue = KBProperty.TRANSACTIONDISPATCHSTRATEGY.get(this.dispatchConnection.m_props);
            }
            SqlParser oscarParser = new SqlParser(sql, this.strategyValue);
            try {
                Statement sqlStmt = oscarParser.doParse(this.dispatchConnection);
                this.strategyValue = oscarParser.getStrategyValue();
                if (sqlStmt instanceof BeginStatement || !(sqlStmt instanceof EndStatement)) {
                    // empty if block
                }
                this.sqlType = null;
                int type = sqlStmt.getSQLType();
                switch (type) {
                    case 0: {
                        result = 0;
                        this.sqlType = TYPE_INTRANSACTION;
                        this.add();
                        break;
                    }
                    case 2: {
                        result = 1;
                        result = this.changeExecuteType();
                        this.sqlType = TYPE_SELECT;
                        break;
                    }
                    case 5: {
                        result = 2;
                        this.sqlType = TYPE_SET;
                        this.add();
                        break;
                    }
                    default: {
                        result = 0;
                        this.sqlType = TYPE_UPDATE;
                        this.add();
                    }
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, " getExecuteType (session={0} sql={1} sqlType={2})", new Object[]{this.dispatchConnection, sql, this.sqlType});
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block12;
                LOGGER.log(Level.SEVERE, " prase (Exception={0})", new Object[]{e.getMessage()});
                LOGGER.log(Level.SEVERE, e);
            }
        }
        this.currentDispatchType = result;
        return result;
    }

    protected int getExecuteType() {
        return this.dispatchType;
    }

    protected int getCurrentExecuteType() {
        return this.currentDispatchType;
    }

    protected ParameterList recordParamlist(java.sql.Statement st) {
        ParameterList prepl = null;
        if (st instanceof KbPreparedStatement) {
            prepl = ((KbPreparedStatement)st).getPreParmlist();
        } else if (st instanceof KbCallableStatement) {
            prepl = ((KbCallableStatement)st).getPreParmlist();
        }
        return prepl;
    }

    protected void resetParamlist(java.sql.Statement st, ParameterList prepl) {
        if (st instanceof KbPreparedStatement) {
            ((KbPreparedStatement)st).setPreParmlist(prepl);
        } else if (st instanceof KbCallableStatement) {
            ((KbCallableStatement)st).setPreParmlist(prepl);
        }
    }

    protected void resetStmtInfo(java.sql.Statement current_st, java.sql.Statement record_st) {
        if (current_st instanceof KbStatement) {
            ((KbStatement)current_st).copyStatementInfo((KbStatement)record_st);
        }
        if (current_st instanceof KbPreparedStatement) {
            ((KbPreparedStatement)current_st).copyPreparedStatementInfo((KbPreparedStatement)record_st);
        }
        if (current_st instanceof KbCallableStatement) {
            ((KbCallableStatement)current_st).copyCallableStatementInfo((KbCallableStatement)record_st);
        }
    }

    protected <R> R executeTemplet(ExecuteCommand<R> command, int dispatchType) throws SQLException {
        String debugmsg;
        this.currentDispatchType = dispatchType;
        R r = null;
        StringBuilder sql = null;
        java.sql.Statement st = null;
        if (LOGGER.isLoggable(Level.INFO)) {
            sql = new StringBuilder();
            sql.append("Main session: ").append(this.dispatchConnection).append(", ").append(DispatchAbstractStatement.class).append(", executeTemplet()" + command.getFunctionName() + " ,dispatchType :").append(dispatchType + " ");
            debugmsg = String.format("executeTemplet (Main session={%s} command={%s} dispatchType={%s})", this.dispatchConnection, command.getFunctionName(), dispatchType);
            LOGGER.log(Level.INFO, debugmsg);
        }
        AtomicLong t1 = new AtomicLong(System.currentTimeMillis());
        switch (dispatchType) {
            case 0: {
                try {
                    st = this.getMainStatement();
                    if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                        debugmsg = String.format("Send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                        LOGGER.log(Level.INFO, debugmsg);
                    }
                    r = command.execute(st);
                    break;
                }
                catch (SQLException e) {
                    if (this.expectionHandler(e, null, null) && !this.sqlType.equalsIgnoreCase(TYPE_INTRANSACTION) && !command.getFunctionName().contains("executeBatch")) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.log(Level.INFO, "Error Main statement url:" + ((KbConnection)st.getConnection()).getURL() + "\n");
                        }
                        int loop = this.dispatchConnection.retrytimes;
                        int interval = this.dispatchConnection.retryinterval;
                        while (loop-- > 0) {
                            try {
                                this.dispatchConnection.CloseConnectCluter();
                                this.dispatchConnection.ReConnectCluter();
                                this.dispatchConnection.CheckClusteInfo(this.dispatchConnection.m_props);
                                if (!this.dispatchConnection.CheckIsMaster(this.dispatchConnection.getMainConn())) {
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, "Connect Main error retry connect:" + loop + "\n");
                                    }
                                    Thread.sleep(interval * 1000);
                                    continue;
                                }
                                this.cleanStatement();
                                st = this.getMainStatement();
                                this.resetStmtInfo(st, this.record_main_stmt);
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to master statement, send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                                    LOGGER.log(Level.INFO, debugmsg);
                                }
                                r = command.execute(st);
                                this.currentDispatchType = 0;
                                this.dispatchType = 0;
                                break;
                            }
                            catch (SQLException ei) {
                                if (!this.expectionHandler(ei, null, null)) {
                                    throw ei;
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to master SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                    LOGGER.log(Level.INFO, debugmsg);
                                }
                                if (loop > 0) {
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, "Connect Main error retry connect:" + loop + " Exception \n");
                                    }
                                    try {
                                        Thread.sleep(interval * 1000);
                                    }
                                    catch (InterruptedException e1) {
                                        LOGGER.log(Level.SEVERE, e1);
                                    }
                                    continue;
                                }
                                debugmsg = String.format("Send to master retry maximnum times still SQLException: %s", ei.getMessage());
                                if (LOGGER.isLoggable(Level.SEVERE)) {
                                    LOGGER.log(Level.SEVERE, debugmsg);
                                    LOGGER.log(Level.SEVERE, ei);
                                }
                                throw new KSQLException(debugmsg, KSQLState.CONNECTION_UNABLE_TO_CONNECT);
                            }
                            catch (InterruptedException e1) {
                                LOGGER.log(Level.SEVERE, e1);
                            }
                        }
                        if (loop > 0) break;
                        throw e;
                    }
                    if (LOGGER.isLoggable(Level.INFO)) {
                        debugmsg = String.format("failare execute in Master Exception: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                        LOGGER.log(Level.INFO, debugmsg);
                    }
                    throw e;
                }
            }
            case 1: {
                try {
                    st = this.getSlaveStatement();
                    if (st == null) {
                        this.slaveStatement = st = this.getMainStatement();
                        this.record_slave_stmt = st;
                        if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                            debugmsg = String.format("getSlaveStatement error ,send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                            LOGGER.log(Level.INFO, debugmsg);
                        }
                        this.currentDispatchType = 0;
                        r = command.execute(st);
                        break;
                    }
                    if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                        debugmsg = String.format("Send to slave session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                        LOGGER.log(Level.INFO, debugmsg);
                    }
                    r = command.execute(st);
                    break;
                }
                catch (SQLException e) {
                    int loop = this.dispatchConnection.retrytimes;
                    int interval = this.dispatchConnection.retryinterval;
                    while (loop-- > 0) {
                        try {
                            if (this.currentDispatchType == 1) {
                                this.currentDispatchType = 0;
                                this.cleanStatement();
                                st = this.getMainStatement();
                                this.resetStmtInfo(st, this.record_slave_stmt);
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to slave exception: (%s) ,change this to master db: (master={%s}).Send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", e.getMessage(), ((KbConnection)st.getConnection()).getHostIp(), this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                                    LOGGER.log(Level.INFO, debugmsg);
                                }
                                r = command.execute(st);
                                if (!this.expectionHandler(e, null, null)) break;
                                this.dispatchConnection.setSlaveToFakebyKey(this.slavekey);
                                break;
                            }
                            this.currentDispatchType = 0;
                            this.dispatchType = 0;
                            this.dispatchConnection.CloseConnectCluter();
                            this.dispatchConnection.ReConnectCluter();
                            this.dispatchConnection.CheckClusteInfo(this.dispatchConnection.m_props);
                            if (this.dispatchConnection.getMainConn() == null) {
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    LOGGER.log(Level.INFO, "Connect Main error retry connect:" + loop + "\n");
                                }
                                Thread.sleep(interval * 1000);
                                continue;
                            }
                            this.cleanStatement();
                            st = this.getMainStatement();
                            this.resetStmtInfo(st, this.record_main_stmt);
                            if (LOGGER.isLoggable(Level.INFO)) {
                                debugmsg = String.format("Send switch slave to master session, send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                                LOGGER.log(Level.INFO, debugmsg);
                            }
                            r = command.execute(st);
                            break;
                        }
                        catch (SQLException ei) {
                            if (!this.expectionHandler(ei, null, null)) {
                                throw ei;
                            }
                            if (LOGGER.isLoggable(Level.INFO)) {
                                debugmsg = String.format("Send to master from switch slave SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                LOGGER.log(Level.INFO, debugmsg);
                            }
                            if (loop > 0) {
                                try {
                                    Thread.sleep(interval * 1000);
                                }
                                catch (InterruptedException e1) {
                                    LOGGER.log(Level.SEVERE, e1);
                                }
                                continue;
                            }
                            debugmsg = String.format("Send to master from switch slave retry failare maxtimes still SQLException: %s", e.getMessage());
                            if (LOGGER.isLoggable(Level.INFO)) {
                                LOGGER.log(Level.INFO, debugmsg);
                            }
                            throw new KSQLException(debugmsg, KSQLState.CONNECTION_UNABLE_TO_CONNECT);
                        }
                        catch (InterruptedException e1) {
                            LOGGER.log(Level.SEVERE, e1);
                        }
                    }
                    if (loop > 0) break;
                    throw e;
                }
            }
            case 2: {
                List<java.sql.Statement> list = this.getAllStatement();
                if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                    debugmsg = String.format("Send to all session: (sql={%s},sqlType={%s})", sql.toString(), this.sqlType);
                    LOGGER.log(Level.INFO, debugmsg);
                }
                for (java.sql.Statement t : list) {
                    try {
                        r = command.execute(t);
                    }
                    catch (SQLException e) {
                        if (!this.expectionHandler(e, null, null) && ((KbConnection)t.getConnection()).isSlave()) break;
                        if (this.expectionHandler(e, null, null) && !this.sqlType.equalsIgnoreCase(TYPE_INTRANSACTION) && !command.getFunctionName().contains("executeBatch")) {
                            int loop = this.dispatchConnection.retrytimes;
                            int interval = this.dispatchConnection.retryinterval;
                            while (loop-- > 0) {
                                try {
                                    this.dispatchConnection.CloseConnectCluter();
                                    this.dispatchConnection.ReConnectCluter();
                                    this.dispatchConnection.CheckClusteInfo(this.dispatchConnection.m_props);
                                    if (this.dispatchConnection.getMainConn() == null) {
                                        if (LOGGER.isLoggable(Level.INFO)) {
                                            LOGGER.log(Level.INFO, "Connect Main error retry connect:" + loop + "\n");
                                        }
                                        Thread.sleep(interval * 1000);
                                        continue;
                                    }
                                    this.cleanStatement();
                                    st = this.getMainStatement();
                                    this.resetStmtInfo(st, this.record_main_stmt);
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        debugmsg = String.format("Send to all statement,send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                                        LOGGER.log(Level.INFO, debugmsg);
                                    }
                                    r = command.execute(st);
                                    this.currentDispatchType = 0;
                                    this.dispatchType = 0;
                                    break;
                                }
                                catch (SQLException ei) {
                                    if (!this.expectionHandler(ei, null, null)) {
                                        throw ei;
                                    }
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        debugmsg = String.format("Send to AllStatement SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                        LOGGER.log(Level.INFO, debugmsg);
                                    }
                                    if (loop > 0) {
                                        try {
                                            Thread.sleep(interval * 1000);
                                        }
                                        catch (InterruptedException e1) {
                                            LOGGER.log(Level.SEVERE, e1);
                                        }
                                        continue;
                                    }
                                    debugmsg = String.format("Send to AllStatement retry maxtimes still SQLException: %s", ei.getMessage());
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, debugmsg);
                                    }
                                    throw new KSQLException(debugmsg, KSQLState.CONNECTION_UNABLE_TO_CONNECT);
                                }
                                catch (InterruptedException e1) {
                                    LOGGER.log(Level.SEVERE, e1);
                                }
                            }
                            if (loop > 0) continue;
                            throw e;
                        }
                        if (LOGGER.isLoggable(Level.INFO)) {
                            debugmsg = String.format("failare execute in all main and slave SQLException: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                            LOGGER.log(Level.INFO, debugmsg);
                        }
                        throw e;
                    }
                }
                for (int i = 1; i < list.size() - 1; ++i) {
                    list.get(i).close();
                }
                break;
            }
            case 3: {
                List<java.sql.Statement> lis = this.getAllCurrentStatement();
                if (LOGGER.isLoggable(Level.INFO)) {
                    sql.append(", send to current:");
                    for (java.sql.Statement t : lis) {
                        sql.append("session : ").append(this.dispatchConnection).append(" , url:").append(((KbConnection)t.getConnection()).getURL() + " st" + st).append(" , ");
                    }
                    debugmsg = String.format("Send to current session: (sql={%s},sqlType={%s})", sql.toString(), this.sqlType);
                    LOGGER.log(Level.INFO, debugmsg);
                }
                for (java.sql.Statement t : lis) {
                    try {
                        r = command.execute(t);
                    }
                    catch (SQLException e) {
                        if (this.expectionHandler(e, null, null) && !this.sqlType.equalsIgnoreCase(TYPE_INTRANSACTION) && !command.getFunctionName().contains("executeBatch")) {
                            int loop = this.dispatchConnection.retrytimes;
                            int interval = this.dispatchConnection.retryinterval;
                            while (loop-- > 0) {
                                try {
                                    this.dispatchConnection.CloseConnectCluter();
                                    this.dispatchConnection.ReConnectCluter();
                                    this.dispatchConnection.CheckClusteInfo(this.dispatchConnection.m_props);
                                    if (this.dispatchConnection.getMainConn() == null) {
                                        if (LOGGER.isLoggable(Level.INFO)) {
                                            LOGGER.log(Level.INFO, "Connect Main error retry connect:" + loop + "\n");
                                        }
                                        Thread.sleep(interval * 1000);
                                        continue;
                                    }
                                    this.cleanStatement();
                                    st = this.getMainStatement();
                                    this.resetStmtInfo(st, this.record_main_stmt);
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        debugmsg = String.format("Send to current statement,send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                                        LOGGER.log(Level.INFO, debugmsg);
                                    }
                                    r = command.execute(st);
                                    this.currentDispatchType = 0;
                                    this.dispatchType = 0;
                                    break;
                                }
                                catch (SQLException ei) {
                                    if (!this.expectionHandler(ei, null, null)) {
                                        throw ei;
                                    }
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        debugmsg = String.format("Send to current SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                        LOGGER.log(Level.INFO, debugmsg);
                                    }
                                    if (loop > 0) {
                                        try {
                                            Thread.sleep(interval * 1000);
                                        }
                                        catch (InterruptedException e1) {
                                            LOGGER.log(Level.SEVERE, e1);
                                        }
                                        continue;
                                    }
                                    debugmsg = String.format("Send to current retry failare maxtimes still SQLException: %s", ei.getMessage());
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, debugmsg);
                                    }
                                    throw new KSQLException(debugmsg, KSQLState.CONNECTION_UNABLE_TO_CONNECT);
                                }
                                catch (InterruptedException e1) {
                                    LOGGER.log(Level.SEVERE, e1);
                                }
                            }
                            if (loop > 0) continue;
                            throw e;
                        }
                        if (LOGGER.isLoggable(Level.INFO)) {
                            debugmsg = String.format("failare execute in current statement SQLException: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                            LOGGER.log(Level.INFO, debugmsg);
                        }
                        throw e;
                    }
                }
                break;
            }
        }
        if (command.isExecuteFunction()) {
            AtomicLong t2 = new AtomicLong(System.currentTimeMillis() - t1.get());
            if (LOGGER.isLoggable(Level.INFO)) {
                if (st instanceof PreparedStatement) {
                    LOGGER.log(Level.INFO, command.getFunctionName().substring(0, command.getFunctionName().length() - 1) + st + ") consume time:::" + t2.get() + "(ms)");
                } else {
                    LOGGER.log(Level.INFO, command.getFunctionName() + " consume time:::" + t2.get() + "(ms)");
                }
            }
        }
        return r;
    }

    protected boolean getErrorCode(SQLException e) {
        boolean flag = false;
        if (e.getSQLState() == null) {
            flag = true;
            return flag;
        }
        if (e.getSQLState().equals("08001") || e.getSQLState().equals("08003") || e.getSQLState().equals("08004") || e.getSQLState().equals("08006") || e.getSQLState().equals("08007") || e.getSQLState().equals("57P01") || e.getSQLState().equals("57P02") || e.getSQLState().equals("57P03")) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "getErrorCode: (SQLState={0},Message={1})", new Object[]{e.getSQLState(), e.getMessage()});
            }
            flag = true;
        }
        return flag;
    }

    private Integer changeExecuteType() {
        int result = 1;
        String rate = KBProperty.HOSTLOADRATE.get(this.dispatchConnection.m_props);
        if (Integer.valueOf(rate) > 0) {
            BigDecimal hostRate;
            String url = this.dispatchConnection.url;
            if (ConnectionMangerV2.totalAcount.get(url).get() == Integer.MAX_VALUE) {
                hostRate = new BigDecimal(ConnectionMangerV2.hostAcount.get(url).get()).divide(new BigDecimal(ConnectionMangerV2.totalAcount.get(url).get()), 2, 1);
                ConnectionMangerV2.totalAcount.get(url).set(100);
                ConnectionMangerV2.hostAcount.get(url).set(hostRate.multiply(new BigDecimal(100)).intValue());
            }
            ConnectionMangerV2.totalAcount.get(url).incrementAndGet();
            if (ConnectionMangerV2.hostAcount.get(url).get() > 0) {
                hostRate = new BigDecimal(ConnectionMangerV2.hostAcount.get(url).get()).divide(new BigDecimal(ConnectionMangerV2.totalAcount.get(url).get()), 2, 1);
                if (hostRate.multiply(new BigDecimal(100)).compareTo(new BigDecimal(rate)) == -1) {
                    result = 0;
                    ConnectionMangerV2.hostAcount.get(url).incrementAndGet();
                }
            } else {
                result = 0;
                ConnectionMangerV2.hostAcount.get(url).incrementAndGet();
            }
        }
        return result;
    }

    public void add() {
        if (KBProperty.HOSTLOADRATE.getIntNoCheck(this.dispatchConnection.m_props) > 0) {
            String url = this.dispatchConnection.url;
            if (ConnectionMangerV2.totalAcount.get(url).get() == Integer.MAX_VALUE) {
                BigDecimal hostRate = new BigDecimal(ConnectionMangerV2.hostAcount.get(url).get()).divide(new BigDecimal(ConnectionMangerV2.totalAcount.get(url).get()), 2, 1);
                ConnectionMangerV2.totalAcount.get(url).set(100);
                ConnectionMangerV2.hostAcount.get(url).set(hostRate.multiply(new BigDecimal(100)).intValue());
            }
            ConnectionMangerV2.totalAcount.get(url).incrementAndGet();
            ConnectionMangerV2.hostAcount.get(url).incrementAndGet();
        }
    }

    protected StatementCreateCommand<? extends java.sql.Statement> getCommand() {
        return this.createCommand;
    }

    protected abstract void initStatement(java.sql.Statement var1) throws SQLException;

    protected abstract boolean expectionHandler(SQLException var1, java.sql.Statement var2, java.sql.Statement var3) throws SQLException;

    protected static interface ExecuteCommand<R> {
        public boolean isExecuteFunction();

        public String getFunctionName();

        public R execute(java.sql.Statement var1) throws SQLException;
    }
}

