package com.matrix.md.xdb.controller;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.matrix.md.xdb.entity.User;
import com.matrix.md.xdb.mapper.XdbUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author matrix
 * @since 2020-05-12
 */
@RestController
@RequestMapping("/xdb/user")
public class XdbUserController {

    @Autowired
    private XdbUserMapper userMapper;

    @GetMapping
    public ResponseEntity findUsers() {
        return ResponseEntity.ok(userMapper.selectList(Wrappers.emptyWrapper()));
    }

    @PostMapping
    public ResponseEntity insertUsers(@RequestBody User user) {
        int i = userMapper.insert(user);
        return ResponseEntity.ok(i);
    }

}
