package com.matrix.md.ydb.controller;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.matrix.md.ydb.entity.User;
import com.matrix.md.ydb.mapper.YdbUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author matrix
 * @since 2020-05-12
 */
@RestController
@RequestMapping("/ydb/user")
public class YdbUserController {

    @Autowired
    private YdbUserMapper userMapper;

    @GetMapping
    public ResponseEntity findUsers() {
        return ResponseEntity.ok(userMapper.selectList(Wrappers.emptyWrapper()));
    }

    @PostMapping
    public ResponseEntity insertUsers(@RequestBody User user) {
        int i = userMapper.insert(user);
        return ResponseEntity.ok(i);
    }

}
