package com.matrix.md.sdb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

import com.matrix.md.sdb.entity.vo.ColumnVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 表里每一列的结构信息
 *
 * @author matrix
 * @since 2020-05-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ColumnInfo对象")
public class ColumnInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "主键，雪花算法生成不能为空")
    @ApiModelProperty("主键，雪花算法生成")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @NotBlank(message = "列名不能为空")
    @ApiModelProperty("列名")
    private String name;

    @NotBlank(message = "列的数据类型不能为空")
    @ApiModelProperty("列的数据类型")
    private String dataType;

    @NotNull(message = "是否可以为空,0不能为空,1可以为空不能为空")
    @ApiModelProperty("是否可以为空,0不能为空,1可以为空")
    private Integer isNull;

    @NotNull(message = "该列所属的表的主键id,是逻辑外键不能为空")
    @ApiModelProperty("该列所属的表的主键id,是逻辑外键")
    private Long tableInfoId;


}
