package com.matrix.md.sdb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 数据库信息
 *
 * @author matrix
 * @since 2020-05-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DatabaseInfo对象")
@TableName(resultMap = "databaseMap")
public class DatabaseInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "主键，雪花算法生成不能为空")
    @ApiModelProperty("主键，雪花算法生成")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @NotBlank(message = "库名不能为空")
    @ApiModelProperty("库名")
    private String name;

    @NotBlank(message = "库地址不能为空")
    @ApiModelProperty("库地址")
    private String address;

    @NotNull(message = "库类型(1为写入方的前置库,2为读取方的前置库)不能为空")
    @ApiModelProperty("库类型(1为写入方的前置库,2为读取方的前置库)")
    private Integer dbType;

    @NotNull(message = "该库所属的平台主键id,是逻辑外键不能为空")
    @ApiModelProperty("该库所属的平台主键id,是逻辑外键")
    private Long platformId;

    @TableField(exist = false)
    private List<TableInfo> tableInfoList = new ArrayList<>();

}
