package com.matrix.md.sdb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.matrix.md.sdb.entity.vo.TableVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 每个平台对应的表信息
 *
 * @author matrix
 * @since 2020-05-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TableInfo对象")
@TableName(resultMap = "tableMap")
public class TableInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "主键，雪花算法生成不能为空")
    @ApiModelProperty(value = "主键，雪花算法生成",position = 0)
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @NotBlank(message = "表名不能为空")
    @ApiModelProperty(value = "表名",position = 1)
    private String name;

    @ApiModelProperty(value = "建立类型(0代表由共享平台自行建立,1代表由写入方/读取方发起建立请求)",position = 2)
    private Integer buildType;

    @NotNull(message = "该表所属的数据库主键id，是逻辑外键不能为空")
    @ApiModelProperty(value = "该表所属的数据库主键id，是逻辑外键",position = 3)
    private Long databaseId;

    @TableField(exist = false)
    @ApiModelProperty(position = 4)
    private List<ColumnInfo> columnInfos;


}
