package com.matrix.md.sdb.entity.vo;

import com.matrix.md.sdb.entity.TableInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * TableVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/5/15 at 2:29 下午
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel("用于视图层操作的表对象，里面记录了表结构信息")
public class TableVo {

    @ApiModelProperty(value = "要新建的表名", example = "student", position = 0)
    private String tableName;

    @ApiModelProperty(value = "要新建的列信息", position = 1)
    private List<ColumnVo> columnVoList;

    public TableInfo trans2Table(Integer buildType){
        return new TableInfo()
                .setName(tableName)
                .setBuildType(1);
    }
}
