use sdb;

# platform
drop table if exists platform_info;

create table platform_info
(
    id   bigint       not null comment '主键，雪花算法生成',
    name varchar(255) not null comment '平台名',
    type tinyint      not null comment '平台类型(1为写入方平台,2为读取方平台,3为同时是写入方与读取方平台)',
    primary key (id)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8 comment '平台信息';

# database
drop table if exists database_info;

create table database_info
(
    id          bigint       not null comment '主键，雪花算法生成',
    name        varchar(255) not null comment '库名',
    address     varchar(255) not null comment '库地址',
    db_type     tinyint      not null comment '库类型(1为写入方的前置库,2为读取方的前置库)',
    platform_id bigint       not null comment '该库所属的平台主键id,是逻辑外键',
    primary key (id)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8 comment '数据库信息';

drop table if exists table_info;

# table

create table table_info
(
    id          bigint       not null comment '主键，雪花算法生成',
    name        varchar(255) not null comment '表名',
    build_type  tinyint      not null default 1 comment '建立类型(0代表由共享平台自行建立,1代表由写入方/读取方发起建立请求)',
    database_id bigint       not null comment '该表所属的数据库主键id，是逻辑外键',
    primary key (id)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8 comment '每个平台对应的表信息';

# column

drop table if exists column_info;

create table column_info
(
    id            bigint       not null comment '主键，雪花算法生成',
    name          varchar(255) not null comment '列名',
    data_type          varchar(50)  not null comment '列的数据类型',
    is_null       tinyint      not null comment '是否可以为空,0不能为空,1可以为空',
    table_info_id bigint       not null comment '该列所属的表的主键id,是逻辑外键',
    primary key (id)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8 comment '表里每一列的结构信息';


