package com.matrix.md;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.matrix.md.sdb.entity.ColumnInfo;
import com.matrix.md.sdb.entity.DatabaseInfo;
import com.matrix.md.sdb.entity.PlatformInfo;
import com.matrix.md.sdb.entity.TableInfo;
import com.matrix.md.sdb.mapper.ColumnInfoMapper;
import com.matrix.md.sdb.mapper.DatabaseInfoMapper;
import com.matrix.md.sdb.mapper.PlatformInfoMapper;
import com.matrix.md.sdb.mapper.TableInfoMapper;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Lists;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.List;

import static org.junit.Assert.*;

/**
 * com.matrix.md.BenchmarkTest.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/5/14 at 4:36 下午
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
public class BenchmarkTest {

    @Autowired
    private PlatformInfoMapper platformInfoMapper;

    @Autowired
    private DatabaseInfoMapper databaseInfoMapper;

    @Autowired
    private TableInfoMapper tableInfoMapper;

    @Autowired
    private ColumnInfoMapper columnInfoMapper;

    @Test
    public void initPlatAndDb(){
        //insert platform
        platformInfoMapper.delete(Wrappers.emptyWrapper());
        PlatformInfo platform = new PlatformInfo().setName("test-writer")
                .setType(1);
        platformInfoMapper.insert(platform);
        Long nextPlatformId = platform.getId();
        log.info("nextPlatformId : {}", nextPlatformId);

        //insert database
        DatabaseInfo database = new DatabaseInfo().setName("User")
                .setDbType(1)
                .setAddress("localhost:mysql:3306")
                .setPlatformId(nextPlatformId);
        databaseInfoMapper.insert(database);
    }


    @Test
    public void insertInitData() {
        //insert platform
        platformInfoMapper.delete(Wrappers.emptyWrapper());
        PlatformInfo platform = new PlatformInfo().setName("test-writer")
                .setType(1);
        platformInfoMapper.insert(platform);
        Long nextPlatformId = platform.getId();
        log.info("nextPlatformId : {}", nextPlatformId);

        //insert database
        DatabaseInfo database = new DatabaseInfo().setName("User")
                .setDbType(1)
                .setAddress("localhost:mysql:3306")
                .setPlatformId(nextPlatformId);
        databaseInfoMapper.insert(database);
        Long nextDatabaseId = database.getId();
        log.info("nextDatabaseId : {}", nextDatabaseId);

        // insert table
        TableInfo table = new TableInfo().setId(null)
                .setBuildType(1)
                .setDatabaseId(nextDatabaseId)
                .setName("test")
                .setColumnInfos(Lists.emptyList());
        tableInfoMapper.insert(table);
        Long nextTableId = table.getId();
        log.info("nextTableId : {}", nextTableId);

        // insert columns
        ColumnInfo column1 = new ColumnInfo().setId(null)
                .setIsNull(0)
                .setName("user_name")
                .setDataType("varchar(255)")
                .setTableInfoId(nextTableId);
        ColumnInfo column2 = new ColumnInfo().setId(null)
                .setIsNull(0)
                .setName("user_age")
                .setDataType("int")
                .setTableInfoId(nextTableId);
        columnInfoMapper.insert(column1);
        columnInfoMapper.insert(column2);

        //check platform not null
        PlatformInfo resultPlatform = platformInfoMapper.selectOne(Wrappers.emptyWrapper());
        assertNotNull(resultPlatform);

        //check database
        List<DatabaseInfo> resultDatabaseInfoList = resultPlatform.getDatabaseInfoList();
        assertTrue(resultDatabaseInfoList.size() >= 1);

        //check table
        TableInfo tableResult = tableInfoMapper.selectOne(Wrappers.emptyWrapper());
        assertNotNull(tableResult);

        // check columnList size large than 1
        List<ColumnInfo> columnResults = tableResult.getColumnInfos();
        assertTrue(columnResults.size() > 1);

        //check if nextTableId successfully cascade
        columnResults.forEach(column ->
                assertEquals(nextTableId, column.getTableInfoId()));

    }

    @Test
    public void deleteAllData(){
        platformInfoMapper.delete(Wrappers.emptyWrapper());
        databaseInfoMapper.delete(Wrappers.emptyWrapper());
        tableInfoMapper.delete(Wrappers.emptyWrapper());
        columnInfoMapper.delete(Wrappers.emptyWrapper());
    }

    private void printLog(Object context) {
        log.info(context.toString());
    }
}
