# 数据共享DEMO

## 流程

![数据共享平台](./images/数据共享平台.jpg)

整个数据共享平台的数据流向如上图所示，总体来讲系统可以分为三个部分。

为了方便叙述，上图中的应用A在下文中有时会称之为数据写入方，应用B称之为数据读取方。

## DEMO里不完善的点
- 没有验证机制(所有涉及到token相关的接口设计都只是草稿)
- 没有实现同步机制，但是把同步的流程列出来了
- 代码结构没有仔细的整理，例如什么类放什么包下这样
- 关于更新的接口没有实现
- 接口里缺少一些关于参数的验证

:)

### 数据写入方与共享平台

**写入**

对于前置库X，数据写入方拥有者数据写入的控制权，即应用A拥有决定是否要写入数据，写入什么数据的权利。但是，在实际写入的时候，写入的操作是由数据共享平台来执行的，也就是说数据共享平台对于写入是一个反向代理的操作。

为什么这么做？因为考虑到了应用A本身不一定拥有对前置库X写入的能力（或许只是一个单纯提供数据的接口），因此决定写入的操作由共享平台来代理操作。

简单来讲，写入的请求由应用A发起，写入的操作数据共享平台来执行。

**读取**

在这个业务中，共享平台本身的数据均来自于应用A，也就是通过读取前置库X来获得数据。在实际的实现中，因为数据共享平台本身对应用A进行了数据写入的代理，因此在实际实现的时候会有优化操作，但从逻辑上来讲并没有变。

> 综上所述，共享平台对于写入方应当提供以下接口

- 建库建表接口，写入方告知共享平台自己谁，需要建什么库，什么表，共享平台会寻找合适的资源为其建库建表，并建立映射关系。
- 数据写入代理接口，写入方告知共享平台自己需要存入什么数据，共享平台代理进行存储。

### 数据读取方与共享平台

**写入**

对于前置库Y，数据读取方拥有数据写入的控制权，共享平台负责数据写入的代理，与前置库X不同的是，此时的原始数据是在共享平台里，但这对前置库Y的写入控制权并没有影响。

简单来讲，应用B通知共享平台自己需求的数据，共享平台将数据写入前置库Y。

**读取**

在共享平台将数据写入至前置库Y之后，应用B对前置库Y进行数据读取。不过这里还有一点，即在写入中应用B如何知道当前的总数据是怎样的呢？(即共享平台内的数据)，数据共享平台会开放数据目录供应用B来查询决定自己想要哪些数据。

总体的流程如下

`应用B读取数据目录->依据数据目录向共享平台发起写入请求->共享平台代理写入请求将数据写入前置库Y->应用B读取前置库Y`

> 综上所述，共享平台对于读取方应当提供以下接口

- 数据目录接口，提供数据读取方可以读取的数据目录以及其对应的前置库访问地址。
- 申请数据读取接口，读取方告知共享平台自己需要读取什么数据，共享平台将对应的数据建库建，读取方读取前置Y获得实际的数据实例。

### 数据同步

 **同步内容**

这里的数据同步分为两块。

- 前置库X向共享库同步，数据以前置库X为准。简称X同步
- 共享库向前置库Y同步，数据以共享库为准。简称Y同步

**定期同步**

X同步与Y同步本身应定期进行数据校验，如果数据不同，则进行X/Y同步。

**触发同步**

触发同步的机制应当遵循如下几个条件

- 在A平台发起写入请求后，触发X同步
- 在触发X同步后，总是会执行Y同步
- 任意X/Y同步失败后，重复执行一定次数的同步，直到成功或达到同步次数，并记录。

### 可以优化/考虑的点

- 共享平台对于应用A的代理，上文的设计中只是写入的代理，但对于数据操作除了写，具体来讲应当是有增删改查的所有代理，目前DEMO中代理只是简单的增加代理。
- 对于应用B向共享平台申请读取数据，就需要查看数据目录，对于数据目录和应用B是否应当拥有权限的设计，即不同的读取方可以查看到的数据目录是依据其平台权限来决定的。
- 目前前置Y的数据相对于前置X的数据可以看做是简单的数据复制/删减，有没有可能会是数据的增加呢？即根据数据目录/已有数据进行交叉数据整合。

## 接口清单的

### 完整接口

| 接口名                   | 地址        | HTTP METHOD |
| ------------------------ | ----------- | ----------- |
| 身份/权限验证接口(双方)  |             |             |
| 查询库表结构(双方)       |             |             |
| 动态查询表结构(数据目录) | /opt/tables | GET         |
| 动态新增表(写入方)       | /opt/tables | POST        |
| 动态删除表(写入方)       | /opt/tables | DELETE      |
| 动态修改表结构(写入方)   | /opt/tables | PUT         |
| 动态插入表数据(写入方)   | /opt/data   | POST        |
| 动态修改表数据(写入方)   | /opt/data   | PUT         |
| 动态删除表数据(写入方)   | /opt/data   | DELETE      |
| 共享数据请求(读取方)     |             |             |

### 写入方流程

1. 调用身份验证接口，获取token凭证(一段时间内只需获取一次)
2. 查询库表结构，得知关于目前库表的一些信息
3. 调用动态新增表接口，动态的创建表
4. 调用动态插入表数据接口，共享平台将数据插入至指定前置库
5. 检查同步映射表，触发同步机制

### 读取方流程

1. 调用身份验证接口，获取token凭证
2. 查询库表结构/数据目录，得知目前的数据目录
3. 依据数据目录发送读数据的请求
4. 共享平台将对应的数据从S库中写入至Y库中，并建立同步映射关系
5. 一旦同步映射表中的数据发生变动，进行数据同步


## 关键点实现

### 认证接口(获取token)

调用方传入指定信息获取token(只是用姓名密码来举例子)

```json
{
  "platformName" : "平台名",
  "passwd" : "密码"
}
```

平台返回token

```json
{
  "platformName" : "平台名",
  "token" : "xxxxxxx"
}
```


### 写入方与中间平台接口(按swagger里的为准吧)

swagger地址:`http://localhost:8080/doc.html`

平台->库->表->列

**建库建表接口**

建库建表接口，写入方告知共享平台自己谁，需要建什么库，什么表，共享平台会寻找合适的资源为其建库建表，并建立映射关系。

需要附带?token参数

TableInfo  ColumnInfo

```json
{
  "platformName" : "写入方平台id/名",
  "tableName" : "要建立的表名",
  "columnInfo" : [
    {
      "name" : "列名",
      "type" : "列的数据类型",
      "isNull" : "是否可以为空 1为可以/0不可以"
    }
  ]
}
```

1. 检查token映射表，验证token
2. 检查平台与表的映射，查看该表是否已经建立
3. 建立表
4. 更新映射关系`token -> 写入方平台 -> 已经存在的表与结构`

**表结构查询接口**

查询写入方平台目前在中间平台已经建立哪些表以及其具的结构

```json
{
    "platformName": "平台名",
    "tableInfos": [
        {
            "tableName": "表名",
            "tableType" : "0代表结构由共享平台建立,1代表结构由写入方建立",
            "columnInfo": [
                {
                    "name": "列名",
                    "type": "列的数据类型",
                    "isNull": "是否可以为空 1为可以/0不可以"
                }
            ]
        }
    ]
}
```



**数据写入代理接口**

数据写入代理接口，写入方告知共享平台自己需要存入什么数据，共享平台代理进行存储。

需要附带?token参数

```json
{
  "tableName" : "要写入表的表名",
  "columnData":[
    {
      "name" : "列名",
      "value" : "要写入的列的数值"
    }
  ]
}
```



```json
{
	"tableId": 123456,
	"data": [
    {
			"name": "jack",
			"age": 22
		},
		{
			"name" : "rose",
			"age" : 23
		}
  ]
}
```





